/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.tizen.library.sdkutils.util.PlatformUtil;

public class WindowsRegistry {
    public static final String REGISTRY_PATH_OF_SHELL_FOLDER = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    public static final String REGISTRY_LOCAL_APP_DATA_OF_SHELL_FOLDER = "\"Local AppData\"";
    private static final String REG_SZ = "REG_SZ";

    public static String getRegistryValue(String node, String key) {
        if (!PlatformUtil.isWindows()) {
            return null;
        }
        String value = "";
        String query = "reg query \"" + node + "\" /v " + key;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(query);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String encoding = PlatformUtil.CURRENT_CHARSET;
        if (process != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), encoding));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    int index = line.indexOf(REG_SZ);
                    if (index < 0) continue;
                    value = line.substring(index + REG_SZ.length()).trim();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return value;
    }
}

