/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.location.LocationInjector;
import org.tizen.ecp.location.model.GeoLocation;
import org.tizen.ecp.location.ui.LocationCommonControl;
import org.tizen.ecp.location.ui.LocationPane;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.sdb.SDBHelperUtil;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.LogUtil;

public class LocationLogController
extends LocationCommonControl {
    Logger logger = LogUtil.getECPLogger(LocationLogController.class).getLogger();
    @FXML
    AnchorPane rootPane;
    @FXML
    Button buttonInjectMaunalMarkers;
    @FXML
    Button buttonResetManualMarkers;
    @FXML
    Button buttonCancelManual;
    @FXML
    Button buttonInjectLog;
    @FXML
    Button buttonCancelLog;
    @FXML
    Button buttonBrowse;
    @FXML
    TextField textLogfile;
    GeoLocation location;
    boolean isTimerStop = false;

    @FXML
    public void onClickBrowse(ActionEvent actionEvent) {
        Node node = (Node)actionEvent.getSource();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Log File");
        File file = fileChooser.showOpenDialog(node.getScene().getWindow());
        if (file == null) {
            return;
        }
        this.textLogfile.setText(file.getPath());
        this.buttonInjectLog.setDisable(!this.validateLogFile());
    }

    @FXML
    public void OnClickInjectLog(ActionEvent actionEvent) {
        try {
            this.startTask();
        }
        catch (Exception exception) {
            this.logger.severe(exception.getMessage());
            return;
        }
        this.buttonInjectLog.setDisable(true);
        this.buttonCancelLog.setDisable(false);
        this.buttonBrowse.setDisable(true);
        this.textLogfile.setDisable(true);
        LocationPane.mapController.rootPane.setDisable(true);
        LocationPane.manualController.rootPane.setDisable(true);
    }

    @FXML
    public void OnClickCancelLog(ActionEvent actionEvent) {
        this.stopTask();
        this.buttonInjectLog.setDisable(false);
        this.buttonCancelLog.setDisable(true);
        this.buttonBrowse.setDisable(false);
        this.textLogfile.setDisable(false);
        LocationPane.mapController.rootPane.setDisable(false);
        LocationPane.manualController.rootPane.setDisable(false);
    }

    private boolean validateLogFile() {
        File file = new File(this.textLogfile.getText());
        if (!file.exists()) {
            return false;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            if (string == null || !string.startsWith("$GP")) {
                bufferedReader.close();
                return false;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    String getRemoteLogfilePath() {
        return "/opt/usr/media/gps-manager/replay/nmea_replay.log";
    }

    public synchronized void startTask() throws Exception {
        boolean bl = true;
        File file = new File(this.textLogfile.getText());
        if (file.exists()) {
            LocationInjector.getInstance().setMode("1", false);
            bl = SDBHelperUtil.push((String)file.getPath(), (String)this.getRemoteLogfilePath(), (boolean)true);
            if (!bl) {
                MessageBox.error((String)DeviceMessages.getString("LocationLogPage.0"));
                return;
            }
        } else {
            MessageBox.error((String)DeviceMessages.getString("LocationLogPage.1"));
        }
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        ImageView imageView = Images.getImageView((String)"Common", (String)"btn_ic_path.png");
        if (imageView != null) {
            this.buttonBrowse.setText("");
            this.buttonBrowse.setGraphic((Node)imageView);
        }
        this.buttonCancelLog.setDisable(true);
        this.buttonInjectLog.setDisable(true);
    }
}

