/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.network.ui;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.layout.Pane;
import org.json.simple.JSONObject;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.network.NetworkConstants;
import org.tizen.ecp.network.ui.NetworkController;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class NetworkPane
extends ECPPopupPane {
    NetworkController controller;
    Logger logger = LogUtil.getECPLogger(NetworkPane.class).getLogger();

    public void onCreate() {
        EventMgr.getInstance().AddLsn("Network", (ILsn)this);
    }

    public void onShow() {
        MessageSender.getInstance().sendMonitorReq(this.createNetworkConnectMsg("get_link virtio-net-pci.0"));
        MessageSender.getInstance().sendMonitorReq(this.controller.createUsernetMsg());
        MessageSender.getInstance().sendDeviceEcsReq("Network", 0, 123);
    }

    public Pane create() {
        Pane pane;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/org/tizen/ecp/network/ui/Network.fxml");
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
        try {
            pane = (Pane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.controller = (NetworkController)eCPFXMLLoader.getController();
        return pane;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        Ecs.InjectorNtf injectorNtf;
        int n;
        if (generatedMessage instanceof Ecs.InjectorNtf && 123 == (n = (injectorNtf = (Ecs.InjectorNtf)generatedMessage).getAction())) {
            int n2 = injectorNtf.getGroup();
            if (1 == n2) {
                this.controller.clearNetworkInfo();
            } else if (injectorNtf.getData().toStringUtf8().equals(Integer.toString(1))) {
                MessageBox.error((String)NetworkConstants.FAIL_PORT_FORWARDING_ERR);
            } else {
                this.logger.warning("not supported message. action: " + n + " ,group: " + n2);
            }
        }
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
        String string2 = (String)jSONObject.get((Object)"return");
        if (string2.startsWith("hub")) {
            this.controller.clearNetworkInfo();
            this.controller.setNetworkInfo(string2);
            return;
        }
        this.controller.setNetworkInfo(string2);
        if (string2.trim().equals("on")) {
            this.controller.setProtocol("Connect");
        } else if (string2.trim().equals("off")) {
            this.controller.setProtocol("Disconnect");
        }
    }

    private String createNetworkConnectMsg(String string) {
        return JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)string), (String)"Network");
    }
}

