/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.ui;

import java.net.URL;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.tizen.ecp.dialog.ButtonType;
import org.tizen.ecp.dialog.Dialog;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCUtil;
import org.tizen.ecp.nfc.ui.FileListingService;
import org.tizen.ecp.nfc.ui.FileTreeCell;
import org.tizen.ecp.nfc.ui.FileTreeData;
import org.tizen.ecp.nfc.ui.ItemAddWorker;

public class TizenRemoteFileDialog {
    static final URL NFC_CSS = TizenRemoteFileDialog.class.getResource("/org/tizen/ecp/nfc/ui/nfc.css");
    static final Color TEXT_FILL_NORMAL = Color.web((String)"#585858");
    private static int DIALOG_WIDTH = 350;
    private static int DIALOG_HEIGHT = 450;
    private static int CONTENT_PADDING = 10;
    private static int PATH_SPACING = 10;
    Dialog<String> dialog;
    TreeItem<FileTreeData> treeRoot;
    TreeView<FileTreeData> treeView;
    private Label pathLabel;
    private Label errorTextLabel;
    boolean isDirectory;
    SimpleStringProperty selectedFilePathProperty = new SimpleStringProperty();
    SimpleStringProperty guideStringProperty = new SimpleStringProperty();
    private TreeItem<FileTreeData> oldTreeItem;

    public String open() {
        this.dialog = new Dialog();
        this.dialog.setTitle("Select a media file");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().addButonType(ButtonType.OK);
        this.dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, String>(){

            public String call(ButtonType buttonType) {
                return buttonType == ButtonType.CANCEL ? null : TizenRemoteFileDialog.this.selectedFilePathProperty.get();
            }
        });
        final Button button = this.dialog.getDialogPane().getButton(ButtonType.OK);
        this.selectedFilePathProperty.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2 == null) {
                    return;
                }
                boolean bl = false;
                String string3 = "";
                if (TizenRemoteFileDialog.this.isDirectory) {
                    bl = true;
                    string3 = "";
                } else if (NFCUtil.checkFileType(string2) == null) {
                    bl = true;
                    string3 = NFCErrorString.NotMimeType;
                } else {
                    try {
                        if (!NFCUtil.checkFileSize(string2)) {
                            bl = true;
                            string3 = NFCErrorString.BigSizeFile;
                        }
                    }
                    catch (NFCEventException nFCEventException) {
                        bl = true;
                        MessageBox.error((String)(NFCErrorString.MediaFileException + nFCEventException.getMessage()));
                    }
                }
                TizenRemoteFileDialog.this.guideStringProperty.set(string3);
                button.setDisable(bl);
            }
        });
        if (this.dialog.getDialogPane() != null) {
            this.dialog.getDialogPane().setContent(this.makeContent());
        }
        if (button != null) {
            button.setDisable(true);
        }
        return (String)this.dialog.showAndWait();
    }

    private Node makeContent() {
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.getStylesheets().add((Object)NFC_CSS.toExternalForm());
        anchorPane.setPrefSize((double)DIALOG_WIDTH, (double)DIALOG_HEIGHT);
        VBox vBox = new VBox();
        vBox.setSpacing((double)PATH_SPACING);
        anchorPane.getChildren().add((Object)vBox);
        AnchorPane.setBottomAnchor((Node)vBox, (Double)0.0);
        AnchorPane.setTopAnchor((Node)vBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)vBox, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)vBox, (Double)0.0);
        vBox.setPadding(new Insets((double)CONTENT_PADDING));
        HBox hBox = new HBox();
        vBox.getChildren().add((Object)hBox);
        VBox.setMargin((Node)hBox, (Insets)new Insets(0.0));
        this.pathLabel = new Label("Path : ");
        hBox.getChildren().add((Object)this.pathLabel);
        hBox.setAlignment(Pos.CENTER_LEFT);
        this.errorTextLabel = new Label();
        this.guideStringProperty.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2 == null) {
                    return;
                }
                TizenRemoteFileDialog.this.errorTextLabel.setText(string2);
            }
        });
        TreeView<FileTreeData> treeView = this.createFileTreeView();
        if (treeView == null) {
            this.errorTextLabel.setText(NFCErrorString.MediaFileException);
        }
        vBox.getChildren().addAll((Object[])new Node[]{treeView, this.errorTextLabel});
        return anchorPane;
    }

    private TreeView<FileTreeData> createFileTreeView() {
        this.treeRoot = new TreeItem((Object)new FileTreeData());
        this.treeView = new TreeView(this.treeRoot);
        VBox.setVgrow(this.treeView, (Priority)Priority.ALWAYS);
        this.treeView.setCellFactory(FileTreeCell.extractor());
        this.treeView.setShowRoot(false);
        if (this.treeView.getSelectionModel() == null) {
            return null;
        }
        this.treeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<FileTreeData>>(){

            public void changed(ObservableValue<? extends TreeItem<FileTreeData>> observableValue, TreeItem<FileTreeData> treeItem, TreeItem<FileTreeData> treeItem2) {
                if (treeItem2 == null) {
                    return;
                }
                if (treeItem2 == TizenRemoteFileDialog.this.treeRoot) {
                    if (TizenRemoteFileDialog.this.oldTreeItem != null && TizenRemoteFileDialog.this.treeView.getSelectionModel() != null) {
                        TizenRemoteFileDialog.this.treeView.getSelectionModel().select((Object)TizenRemoteFileDialog.this.oldTreeItem);
                    }
                    return;
                }
                if (treeItem2.getValue() == null) {
                    return;
                }
                TizenRemoteFileDialog.this.isDirectory = ((FileTreeData)treeItem2.getValue()).isDirectory();
                TizenRemoteFileDialog.this.selectedFilePathProperty.set(((FileTreeData)treeItem2.getValue()).getFullPath());
                TizenRemoteFileDialog.this.pathLabel.setText("Path : " + TizenRemoteFileDialog.this.selectedFilePathProperty.get());
                TizenRemoteFileDialog.this.oldTreeItem = treeItem2;
            }
        });
        this.treeView.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    TizenRemoteFileDialog.this.dialog.close();
                }
            }
        });
        FileListingService fileListingService = new FileListingService();
        FileListingService.FileEntry fileEntry = fileListingService.getRoot();
        String[] stringArray = "/opt/nfc".substring(1).split("/");
        this.cacheChild(fileEntry, stringArray);
        new ItemAddWorker(fileEntry, this.treeRoot).start();
        return this.treeView;
    }

    private void cacheChild(FileListingService.FileEntry fileEntry, String[] stringArray) {
        FileListingService.FileEntry[] fileEntryArray = fileEntry.getFileListingService().getChildren(fileEntry, true, null);
        block0: for (String string : stringArray) {
            for (FileListingService.FileEntry fileEntry2 : fileEntryArray) {
                if (!string.equals(fileEntry2.getName())) continue;
                fileEntryArray = fileEntry2.getFileListingService().getChildren(fileEntry2, true, null);
                continue block0;
            }
        }
    }
}

