/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.axis.geo;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class SensorMagneticCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, index=0)
    double xValue;
    @Argument(required=true, index=1)
    double yValue;
    @Argument(required=true, index=2)
    double zValue;

    public SensorMagneticCLI() {
        this.messageType = this.TYPE_SENSOR = "sensor";
    }

    private boolean checkRange(double d) {
        return d >= -2000.0 && d <= 2000.0;
    }

    public int execute() {
        if (!this.checkRange(this.xValue)) {
            OutputUtil.println((String)DeviceMessages.getString("SensorMagneticCLI.1"));
            return 25;
        }
        if (!this.checkRange(this.yValue)) {
            OutputUtil.println((String)DeviceMessages.getString("SensorMagneticCLI.2"));
            return 25;
        }
        if (!this.checkRange(this.zValue)) {
            OutputUtil.println((String)DeviceMessages.getString("SensorMagneticCLI.3"));
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(this.xValue, this.yValue, this.zValue);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "13\n" + injectorMessage.getMessage());
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns deviceAns = (Ecs.DeviceAns)generatedMessage;
            int n = deviceAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            MessageSender.getInstance().sendDeviceReq("sensor", 15, 112);
            this.stopRunning();
        }
    }
}

