/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.proximity;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.card.ECPCardPane;

public class ProximityCard
extends ECPCardPane {
    private static Logger logger = LogUtil.getECPLogger(ProximityCard.class).getLogger();

    public ProximityCard() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
    }

    public void onCreate() {
        this.sendStatus();
    }

    public void send(int n) {
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "2\n" + injectorMessage.getMessage());
    }

    public void sendStatus() {
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 114);
    }

    public void cardSelectionChangedListener(boolean bl) {
        if (bl) {
            this.send(0);
        } else {
            this.send(8);
        }
        this.sendStatus();
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        long l;
        int n = -1;
        if (generatedMessage instanceof Ecs.DeviceNtf && 114L == (l = (long)(deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction())) {
            try {
                n = Integer.parseInt(deviceNtf.getData().toStringUtf8());
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Numberformat", numberFormatException);
            }
            if (n == 8) {
                this.selected(false);
                this.setDescription("Far");
            } else if (n == 0) {
                this.selected(true);
                this.setDescription("Near");
            } else {
                logger.warning("Wrong value received: " + n);
            }
        }
    }
}

