/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.battery.ui;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.tizen.ecp.battery.BatteryConstants;
import org.tizen.ecp.battery.ui.BatteryController;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class BatteryPane
extends ECPPopupPane {
    Logger logger = LogUtil.getECPLogger(BatteryPane.class).getLogger();
    private static final String BATTERY_CSS_FILE = "Battery.css";
    private static final URL BATTERY_CSS = BatteryPane.class.getResource("Battery.css");
    BatteryController batteryController;

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 100);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 101);
    }

    public void onShow() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 100);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 101);
    }

    public Pane create() {
        AnchorPane anchorPane;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/org/tizen/ecp/battery/ui/BatteryPopup.fxml");
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
        try {
            anchorPane = (AnchorPane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "battery pane is failed to load fxml.", iOException);
            throw new RuntimeException(iOException);
        }
        anchorPane.getStylesheets().add((Object)BATTERY_CSS.toExternalForm());
        this.batteryController = (BatteryController)eCPFXMLLoader.getController();
        return anchorPane;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            long l = injectorNtf.getAction();
            if (100L == l) {
                String string = injectorNtf.getData().toStringUtf8();
                this.setCardDescription(string + " " + "%");
                if (this.batteryController != null) {
                    this.batteryController.setLevel(Double.valueOf(string) * 2.0, false);
                }
            } else if (101L == l) {
                String string = injectorNtf.getData().toStringUtf8();
                if (this.batteryController != null) {
                    this.batteryController.setCharge(string.equals(BatteryConstants.VALUE_CHARGER_ON), false);
                }
            }
        }
    }
}

