/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.protocol;

import javax.management.RuntimeErrorException;
import org.tizen.ecp.location.LocationConstants;

public class SatelliteInfo {
    private int id;
    private int elevation;
    private int azimuth;
    private int snr;

    public SatelliteInfo(int n, int n2, int n3, int n4) {
        this.setId(n);
        this.setElevation(n2);
        this.setAzimuth(n3);
        this.setSnr(n4);
        if (!this.validate()) {
            throw new RuntimeErrorException(null, LocationConstants.SatelliteInfo_0);
        }
    }

    private boolean validate() {
        if (this.id < 1 || this.id > 32) {
            return false;
        }
        if (this.elevation < 0 || this.elevation > 90) {
            return false;
        }
        if (this.azimuth < 0 || this.id > 359) {
            return false;
        }
        return this.snr >= 0 && this.id <= 99;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void setElevation(int n) {
        this.elevation = n;
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setAzimuth(int n) {
        this.azimuth = n;
    }

    public int getAzimuth() {
        return this.azimuth;
    }

    public void setSnr(int n) {
        this.snr = n;
    }

    public int getSnr() {
        return this.snr;
    }
}

