/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.ultraviolet;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class SensorUVCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, index=0)
    float level;

    public SensorUVCLI() {
        this.messageType = this.TYPE_SENSOR = "sensor";
    }

    public int execute() {
        if (this.level < 0.0f || this.level > 15.0f) {
            OutputUtil.printError((String)DeviceMessages.getString("SensorUVCLI.1"));
            this.printHelp();
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage((int)(this.level * 10.0f));
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "21\n" + injectorMessage.getMessage());
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns deviceAns = (Ecs.DeviceAns)generatedMessage;
            int n = deviceAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            MessageSender.getInstance().sendDeviceReq("sensor", 15, 117);
            this.stopRunning();
        }
    }
}

