/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.ultraviolet;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import org.tizen.ecp.control.TizenSpinner;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class UltravioletPane
extends ECPPopupPane {
    private static Logger logger = LogUtil.getECPLogger(UltravioletPane.class).getLogger();
    private TizenSpinner spinner;

    public Pane create() {
        HBox hBox = new HBox();
        Label label = new Label("Index");
        label.getStyleClass().add((Object)"titleLabel");
        label.setMinWidth(40.0);
        label.setAlignment(Pos.CENTER_LEFT);
        this.spinner = new TizenSpinner(0.0, 15.0, 0.0, 1.0);
        this.spinner.getEditor().setPrefSize(40.0, 24.0);
        HBox.setMargin((Node)label, (Insets)new Insets(0.0, 12.0, 0.0, 40.0));
        HBox.setMargin((Node)this.spinner, (Insets)new Insets(0.0, 52.0, 0.0, 0.0));
        HBox.setHgrow((Node)this.spinner, (Priority)Priority.SOMETIMES);
        hBox.getChildren().add((Object)label);
        hBox.getChildren().add((Object)this.spinner);
        hBox.setAlignment(Pos.CENTER);
        return hBox;
    }

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 117);
    }

    public void onShow() {
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 117);
        this.spinner.valueProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                UltravioletPane.this.sendMessage();
            }
        });
    }

    private void sendMessage() {
        int n = (int)(this.spinner.getValue() * 10.0);
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "21\n" + injectorMessage.getMessage());
        this.setCardDescription((double)((int)(this.spinner.getValue() * 10.0)) / 10.0 + " " + "\u33bc/\u33a0");
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        int n = -1;
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        if (117 == deviceNtf.getAction()) {
            String string = deviceNtf.getData().toStringUtf8();
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Numberformat", numberFormatException);
            }
            this.setCardDescription((double)n / 10.0 + " " + "\u33bc/\u33a0");
            if (this.spinner != null) {
                this.spinner.setValue((double)n / 10.0);
            }
        }
    }
}

