/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.protocol;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteUtil {
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final int BYTE_LENGTH = 1;
    public static final int SHORT_LENGTH = 2;
    public static final int INT_LENGTH = 4;

    public static ByteBuffer getByteBuffer(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.order(BYTE_ORDER);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer getByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(BYTE_ORDER);
        return byteBuffer;
    }

    public static byte[] short2byte(short s) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(s & 0xFF);
        byArray[0] = (byte)(s >>> 8 & 0xFF);
        return byArray;
    }

    public static byte[] int2byte(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n >>> 8 & 0xFF);
        byArray[1] = (byte)(n >>> 16 & 0xFF);
        byArray[0] = (byte)(n >>> 24 & 0xFF);
        return byArray;
    }

    public static byte[] long2byte(long l) {
        byte[] byArray = new byte[8];
        byArray[7] = (byte)(l & 0xFFL);
        byArray[6] = (byte)(l >>> 8 & 0xFFL);
        byArray[5] = (byte)(l >>> 16 & 0xFFL);
        byArray[4] = (byte)(l >>> 24 & 0xFFL);
        byArray[3] = (byte)(l >>> 32 & 0xFFL);
        byArray[2] = (byte)(l >>> 40 & 0xFFL);
        byArray[1] = (byte)(l >>> 48 & 0xFFL);
        byArray[0] = (byte)(l >>> 56 & 0xFFL);
        return byArray;
    }

    public static short byte2short(byte[] byArray) {
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public static int byte2int(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static int byte2int(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static long byte2long(byte[] byArray) {
        return (long)ByteUtil.byte2int(byArray) << 32 | (long)ByteUtil.byte2int(byArray, 4) & 0xFFFFFFFFL;
    }

    public static String byte2hex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static byte[] hex2byte(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    public static void printHex(byte[] byArray, String string) {
        System.out.print("\n### " + string + " : ");
        for (int i = 0; i < byArray.length; ++i) {
            System.out.format("%02X ", byArray[i]);
        }
    }
}

