/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.battery.cli;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class BatteryChargerCLI
extends AbstractEmulatorCLI {
    private static final String COMPLETE = "on off";
    @Argument(required=true, index=0, metaVar="on off")
    String charger;

    public BatteryChargerCLI() {
        this.messageType = "sensor";
    }

    public int execute() {
        int n = 0;
        if (this.charger == null) {
            OutputUtil.printError((String)DeviceMessages.getString("BatteryChargerCLI.3"));
            this.printHelp();
            return 25;
        }
        if (this.charger.toLowerCase().equals("on")) {
            n = 1;
        } else if (this.charger.toLowerCase().equals("off")) {
            n = 0;
        } else {
            OutputUtil.printError((String)DeviceMessages.getString("BatteryChargerCLI.8"));
            OutputUtil.println((String)this.help);
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(2, n);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "8\n" + injectorMessage.getMessage());
        this.startRunning();
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorAns) {
            Ecs.InjectorAns injectorAns = (Ecs.InjectorAns)generatedMessage;
            int n = injectorAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
                OutputUtil.printFail();
                this.stopRunning();
                return;
            }
            MessageSender.getInstance().sendInjectorReq("sensor", 15, 101);
            OutputUtil.printOK();
            this.stopRunning();
        }
    }
}

