/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.protocol;

import java.text.DecimalFormat;
import org.tizen.ecp.location.protocol.AbstractNMEA0183;

public class NMEA0183_GPGSA
extends AbstractNMEA0183 {
    private static String selectionMode = "A";
    private static String mode = "3";
    private int[] satellteIDs = new int[]{1, 2, 3, 4, 5};
    private double pdop = 0.0;
    private double hdop = 0.0;
    private double vdop = 0.0;

    public NMEA0183_GPGSA() {
        super("GPGSA");
        this.createSentence();
    }

    @Override
    protected void createBody() {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.0");
        this.getBody().add(selectionMode);
        this.getBody().add(mode);
        for (int i = 0; i < 12; ++i) {
            if (i >= this.satellteIDs.length) {
                this.getBody().add(NULL);
                continue;
            }
            this.getBody().add(decimalFormat.format(this.satellteIDs[i]));
        }
        this.getBody().add(decimalFormat2.format(this.pdop));
        this.getBody().add(decimalFormat2.format(this.hdop));
        this.getBody().add(decimalFormat2.format(this.vdop));
    }

    @Override
    protected boolean validate() {
        return true;
    }
}

