/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.cli;

import java.util.ArrayList;
import java.util.List;
import org.tizen.ecp.nfc.NDEFFormat;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCUtil;

public class NDEFRecordList {
    private static final int MaxRecordListLength = 4096;
    private static final int MaxRecordCount = 5;
    private final List<NDEFRecord> list = new ArrayList<NDEFRecord>();

    List<NDEFRecord> getList() {
        return this.list;
    }

    private int checkRecordListMaxLength() {
        int n = 0;
        for (NDEFRecord nDEFRecord : this.list) {
            n += 1 + nDEFRecord.toString().length() + 4;
        }
        if (n > 4096) {
            return -1;
        }
        return n;
    }

    void addNDEFRecord(NDEFRecord nDEFRecord) throws NFCEventException {
        if (nDEFRecord == null) {
            throw new NFCEventException(NFCErrorString.NullRecord);
        }
        if (this.list.size() >= 5) {
            throw new NFCEventException(NFCErrorString.RecordCountIsMax);
        }
        NFCUtil.checkInvalidCharacters(nDEFRecord.getId());
        NFCUtil.checkInvalidCharacters(nDEFRecord.getTypeName());
        NFCUtil.checkInvalidCharacters(nDEFRecord.getPayload());
        if (nDEFRecord.getNdefFormat() == NDEFFormat.WELL_KNOWN) {
            if (!nDEFRecord.getTypeName().equals("U") && !nDEFRecord.getTypeName().equals("T")) {
                throw new NFCEventException(NFCErrorString.InvalidWellKnownType);
            }
        } else if (nDEFRecord.getNdefFormat() == NDEFFormat.MEDIA) {
            if (NFCUtil.checkFileType(nDEFRecord.getPayload()) == null) {
                throw new NFCEventException(NFCErrorString.NotMimeType);
            }
            if (!NFCUtil.checkFileSize(nDEFRecord.getPayload())) {
                throw new NFCEventException(NFCErrorString.BigSizeFile);
            }
        }
        this.list.add(nDEFRecord);
        int n = this.checkRecordListMaxLength();
        if (n == -1) {
            this.list.remove(nDEFRecord);
            throw new NFCEventException(NFCErrorString.MessageLenIsMax);
        }
    }

    void removeNDEFRecord(int n) throws NFCEventException {
        try {
            this.list.remove(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NFCEventException(NFCErrorString.FailedRemoveRecord);
        }
        this.checkRecordListMaxLength();
    }
}

