/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.cli;

import java.util.ArrayList;
import java.util.List;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.nfc.NDEFFormat;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCEventInjector;
import org.tizen.ecp.nfc.NFCUtil;
import org.tizen.ecp.nfc.cli.NDEFRecordList;
import org.tizen.ecp.nfc.cli.NFCEventType;
import org.tizen.ecp.nfc.cli.NFCTagType;
import org.tizen.ecp.string.DeviceMessages;

public class NFCCLIHelper {
    private static final String TOKEN = ",";
    private NFCEventType currentEventType = NFCEventType.NONE;
    private List<NDEFRecord> currentRecordList = new ArrayList<NDEFRecord>();

    public NFCCLIHelper(String string) throws NFCEventException {
        if (!NFCUtil.availableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        this.initCurrentNFCStatus(string);
    }

    private void initCurrentNFCStatus(String string) {
        if (string != null) {
            String[] stringArray = string.split(":");
            int n = Integer.valueOf(stringArray[0]);
            for (NFCEventType nFCEventType : NFCEventType.values()) {
                if (n != nFCEventType.getType()) continue;
                this.currentEventType = nFCEventType;
                break;
            }
            if (this.currentEventType == NFCEventType.TAG_DISCOVERED || this.currentEventType == NFCEventType.P2P_SEND) {
                this.currentRecordList = NFCUtil.makeNDEFMessage(stringArray[1]);
            }
        }
    }

    public void printCurrentNFCStatus() {
        OutputUtil.println((String)(DeviceMessages.getString("NFCStatusCLI.1") + this.currentEventType.toString()));
        if (this.currentEventType == NFCEventType.TAG_DISCOVERED || this.currentEventType == NFCEventType.P2P_SEND) {
            OutputUtil.println((String)DeviceMessages.getString("NFCStatusCLI.2"));
            for (NDEFRecord nDEFRecord : this.currentRecordList) {
                OutputUtil.println((String)("\t" + nDEFRecord.toString()));
            }
        }
    }

    private NDEFRecord parseArgs(String string) throws NFCEventException {
        if (string == null) {
            throw new NFCEventException(NFCErrorString.NullRecord);
        }
        String[] stringArray = string.split(TOKEN);
        if (stringArray.length != 4) {
            throw new NFCEventException(NFCErrorString.WrongArgument);
        }
        NDEFFormat nDEFFormat = null;
        for (NDEFFormat nDEFFormat2 : NDEFFormat.values()) {
            if (!nDEFFormat2.getShortName().equals(stringArray[0])) continue;
            nDEFFormat = nDEFFormat2;
            break;
        }
        if (nDEFFormat == null) {
            throw new NFCEventException(NFCErrorString.NotExistNDEFFormat);
        }
        return new NDEFRecord(nDEFFormat, stringArray[1], stringArray[2], stringArray[3]);
    }

    public void sendTagDiscovered(NFCTagType nFCTagType, String string) throws NFCEventException {
        if (this.currentEventType == NFCEventType.TAG_DISCOVERED) {
            throw new NFCEventException(NFCErrorString.TagAttachState);
        }
        if (this.currentEventType == NFCEventType.P2P_DISCOVERED || this.currentEventType == NFCEventType.P2P_SEND) {
            throw new NFCEventException(NFCErrorString.P2PAttachState);
        }
        if (!NFCUtil.availableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        NDEFRecordList nDEFRecordList = new NDEFRecordList();
        nDEFRecordList.addNDEFRecord(this.parseArgs(string));
        if (nDEFRecordList.getList().size() == 0) {
            throw new NFCEventException(NFCErrorString.RecordCountIsZero);
        }
        if (nFCTagType == null || nFCTagType == NFCTagType.P2P) {
            throw new NFCEventException(NFCErrorString.WrongTagType);
        }
        String string2 = NFCEventInjector.sendMessage(NFCEventType.TAG_DISCOVERED, nFCTagType, nDEFRecordList.getList());
        OutputUtil.println((String)("send attach : " + string2));
    }

    public void sendTagDetached() throws NFCEventException {
        if (this.currentEventType != NFCEventType.TAG_DISCOVERED) {
            throw new NFCEventException(NFCErrorString.CanNotDettach);
        }
        if (!NFCUtil.availableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        OutputUtil.println((String)"send tag detach");
        NFCEventInjector.sendMessage(NFCEventType.TAG_DETACHED);
    }

    public void sendP2PDiscovered() throws NFCEventException {
        if (this.currentEventType == NFCEventType.TAG_DISCOVERED) {
            throw new NFCEventException(NFCErrorString.TagAttachState);
        }
        if (this.currentEventType == NFCEventType.P2P_DISCOVERED || this.currentEventType == NFCEventType.P2P_SEND) {
            throw new NFCEventException(NFCErrorString.P2PAttachState);
        }
        if (!NFCUtil.availableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        NFCEventInjector.sendMessage(NFCEventType.P2P_DISCOVERED);
    }

    public void sendP2PSend(String string) throws NFCEventException {
        if (this.currentEventType != NFCEventType.P2P_DISCOVERED && this.currentEventType != NFCEventType.P2P_SEND) {
            throw new NFCEventException(NFCErrorString.CanNotSend);
        }
        if (!NFCUtil.availableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        NDEFRecordList nDEFRecordList = new NDEFRecordList();
        nDEFRecordList.addNDEFRecord(this.parseArgs(string));
        if (nDEFRecordList.getList().size() == 0) {
            throw new NFCEventException(NFCErrorString.RecordCountIsZero);
        }
        NFCEventInjector.sendMessage(NFCEventType.P2P_SEND, NFCTagType.P2P, nDEFRecordList.getList());
    }

    public void sendP2PDetached() throws NFCEventException {
        if (this.currentEventType != NFCEventType.P2P_DISCOVERED && this.currentEventType != NFCEventType.P2P_SEND) {
            throw new NFCEventException(NFCErrorString.CanNotDettach);
        }
        if (!NFCUtil.availableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        NFCEventInjector.sendMessage(NFCEventType.P2P_DETACHED);
    }
}

