/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.cli.sms;

import java.io.IOException;
import java.util.logging.Logger;
import org.tizen.ecp.telephony.cli.TelephonyData;
import org.tizen.ecp.telephony.cli.TelephonyMessage;
import org.tizen.ecp.telephony.cli.TelephonyStringResources;
import org.tizen.ecp.telephony.protocol.ProtocolBuilder;
import org.tizen.ecp.utils.LogUtil;

public class TelephonySMSData {
    private static TelephonySMSData instance = new TelephonySMSData();
    private boolean isMsgReceived = false;
    Logger logger = LogUtil.getECPLogger(TelephonySMSData.class).getLogger();

    public static TelephonySMSData getInstance() {
        return instance;
    }

    public void fireMsgReceived(boolean bl) {
        this.setMsgReceived(bl);
    }

    public boolean sendMessage(String string, String string2) throws IOException {
        if (!TelephonyMessage.getInstance().getRssiStatus()) {
            System.out.println(TelephonyStringResources.RSSIIsZero);
            return false;
        }
        if (!TelephonyData.getInstance().checkNumber(string)) {
            return false;
        }
        if (string2.length() > 80) {
            System.out.println(TelephonyStringResources.MessageIsTooLong);
            return false;
        }
        this.setMsgReceived(false);
        ProtocolBuilder.getInstance().sendMSG(string, (short)-1, string2);
        return true;
    }

    public boolean isMsgReceived() {
        return this.isMsgReceived;
    }

    public void setMsgReceived(boolean bl) {
        this.logger.info("sms received: " + bl);
        this.isMsgReceived = bl;
    }
}

