/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.protocol.sms.crytography;

import java.util.logging.Logger;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.telephony.protocol.sms.crytography.SmsAddressInfo;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_DELIVER;
import org.tizen.ecp.telephony.protocol.sms.crytography.TapiNetTextCodingScheme;
import org.tizen.ecp.telephony.protocol.sms.crytography.TmDateTime;
import org.tizen.ecp.utils.LogUtil;

public class EncodeMsg {
    private int index;
    Logger logger = LogUtil.getECPLogger(EncodeMsg.class).getLogger();

    public int EncodeSmsDeliverTpdu(SmsAddressInfo smsAddressInfo, TPDU_SMS_DELIVER tPDU_SMS_DELIVER, char[] cArray, int n, int n2) {
        int n3;
        char[] cArray2;
        char[] cArray3 = new char[21];
        String string = null;
        this.index = 0;
        if (smsAddressInfo.isInternationalCall()) {
            smsAddressInfo.setNpi(1);
            smsAddressInfo.setTon(1);
            cArray2 = smsAddressInfo.getDiallingNum().substring(1).toCharArray();
        } else {
            smsAddressInfo.setNpi(0);
            smsAddressInfo.setTon(0);
            cArray2 = smsAddressInfo.getDiallingNum().toCharArray();
        }
        if (!this.SmsUtilEncodeAddrField_sca(cArray, cArray2, cArray2.length, smsAddressInfo.getTon(), smsAddressInfo.getNpi())) {
            return -1;
        }
        cArray[this.index] = (char)tPDU_SMS_DELIVER.getMsgType();
        int n4 = this.index;
        cArray[n4] = (char)(cArray[n4] | (tPDU_SMS_DELIVER.isMms() ? 4 : 0));
        int n5 = this.index;
        cArray[n5] = (char)(cArray[n5] | (tPDU_SMS_DELIVER.isSri() ? 32 : 0));
        int n6 = this.index;
        cArray[n6] = (char)(cArray[n6] | (tPDU_SMS_DELIVER.isUdhi() ? 64 : 0));
        int n7 = this.index;
        cArray[n7] = (char)(cArray[n7] | (tPDU_SMS_DELIVER.isRp() ? 128 : 0));
        ++this.index;
        if (tPDU_SMS_DELIVER.getOrgAddr().isInternationalCall()) {
            tPDU_SMS_DELIVER.getOrgAddr().setNpi(1);
            tPDU_SMS_DELIVER.getOrgAddr().setTon(1);
            string = tPDU_SMS_DELIVER.getOrgAddr().getDiallingNum().substring(1);
        } else {
            tPDU_SMS_DELIVER.getOrgAddr().setNpi(0);
            tPDU_SMS_DELIVER.getOrgAddr().setTon(0);
            string = tPDU_SMS_DELIVER.getOrgAddr().getDiallingNum();
        }
        if (!this.SmsUtilEncodeAddrField_dst(cArray, string.toCharArray(), string.length(), tPDU_SMS_DELIVER.getOrgAddr().getTon(), tPDU_SMS_DELIVER.getOrgAddr().getNpi())) {
            return -1;
        }
        cArray[this.index++] = (char)n;
        char c = this.SmsUtilEncodeDCS(tPDU_SMS_DELIVER.getTcs());
        cArray[this.index++] = c;
        this.SmsUtilEncodeTimeStamp(tPDU_SMS_DELIVER.getScts(), cArray3);
        for (n3 = 0; n3 < 7; ++n3) {
            cArray[this.index++] = cArray3[n3];
        }
        switch (tPDU_SMS_DELIVER.getTcs().getAlphabetType()) {
            case 0: {
                cArray[this.index++] = (char)tPDU_SMS_DELIVER.getUserData().getLength();
                this.SmsUtilPackGSMCode(cArray, new String(tPDU_SMS_DELIVER.getUserData().getData()).toCharArray());
                break;
            }
            case 1: {
                cArray[this.index++] = (char)tPDU_SMS_DELIVER.getUserData().getLength();
                this.SmsUtilPackGSM8Code(cArray, new String(tPDU_SMS_DELIVER.getUserData().getData()).toCharArray());
                break;
            }
            case 2: {
                int n8 = 0;
                int n9 = 0;
                int n10 = this.index++;
                if (tPDU_SMS_DELIVER.getUserData().getHeaderCnt() > 0) {
                    this.index += 2;
                }
                int n11 = 6;
                if (tPDU_SMS_DELIVER.isPorted()) {
                    ++this.index;
                    cArray[this.index++] = 5;
                    cArray[this.index++] = 4;
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.getPort() >> 8);
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.getPort() & 0xFF);
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.getPort() >> 8);
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.getPort() & 0xFF);
                    n8 += n11;
                }
                for (n3 = 0; n3 < tPDU_SMS_DELIVER.getUserData().getHeaderCnt(); ++n3) {
                    cArray[this.index++] = 8;
                    cArray[this.index++] = 4;
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.getUserData().getSmsUDH().getMsgRef() >> 8);
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.getUserData().getSmsUDH().getMsgRef() & 0xFF);
                    cArray[this.index++] = tPDU_SMS_DELIVER.getUserData().getSmsUDH().getTotalSeg();
                    cArray[this.index++] = tPDU_SMS_DELIVER.getUserData().getSmsUDH().getSeqNum();
                    n8 += n11;
                }
                if (n8 > 0) {
                    cArray[n10] = (char)(n8 + 1 + n9 + tPDU_SMS_DELIVER.getUserData().getLength());
                    cArray[n10 + 1] = (char)n8;
                } else {
                    cArray[n10] = (char)tPDU_SMS_DELIVER.getUserData().getLength();
                }
                for (byte by : tPDU_SMS_DELIVER.getUserData().getData()) {
                    cArray[this.index++] = (char)by;
                }
                break;
            }
            default: {
                this.logger.warning("Unsupported alphabetType while decoding SMS userdata");
            }
        }
        return this.index;
    }

    private void SmsUtilPackGSMCode(char[] cArray, char[] cArray2) {
        int n = 0;
        for (int i = 0; i < cArray2.length; ++i) {
            cArray[this.index] = (char)(cArray2[i] >> n);
            if (i + 1 < cArray2.length) {
                int n2 = this.index;
                cArray[n2] = (char)(cArray[n2] | cArray2[i + 1] << 7 - n);
                int n3 = this.index;
                cArray[n3] = (char)(cArray[n3] & 0xFF);
                if (++n == 7) {
                    n = 0;
                    ++i;
                }
            }
            ++this.index;
        }
    }

    private void SmsUtilPackGSM8Code(char[] cArray, char[] cArray2) {
        for (int i = 0; i < cArray2.length; ++i) {
            cArray[this.index++] = cArray2[i];
        }
    }

    private void SmsUtilEncodeTimeStamp(TmDateTime tmDateTime, char[] cArray) {
        char[] cArray2 = new char[20];
        this.SmsUtilConvertDigit2BCD(cArray2, String.format("%02d", tmDateTime.getYear() - 2000).toCharArray(), 2L);
        cArray[0] = cArray2[0];
        this.SmsUtilConvertDigit2BCD(cArray2, String.format("%02d", tmDateTime.getMonth()).toCharArray(), 2L);
        cArray[1] = cArray2[0];
        this.SmsUtilConvertDigit2BCD(cArray2, String.format("%02d", tmDateTime.getDay()).toCharArray(), 2L);
        cArray[2] = cArray2[0];
        this.SmsUtilConvertDigit2BCD(cArray2, String.format("%02d", tmDateTime.getHour()).toCharArray(), 2L);
        cArray[3] = cArray2[0];
        this.SmsUtilConvertDigit2BCD(cArray2, String.format("%02d", tmDateTime.getMinute()).toCharArray(), 2L);
        cArray[4] = cArray2[0];
        this.SmsUtilConvertDigit2BCD(cArray2, String.format("%02d", tmDateTime.getSecond()).toCharArray(), 2L);
        cArray[5] = cArray2[0];
        this.SmsUtilConvertDigit2BCD(cArray2, String.format("%02d", tmDateTime.getDay()).toCharArray(), 2L);
        this.SmsUtilConvertDigit2BCD(cArray2, String.format("%02d", 0).toCharArray(), 2L);
        cArray[6] = cArray2[0];
    }

    private char SmsUtilEncodeDCS(TapiNetTextCodingScheme tapiNetTextCodingScheme) {
        char c = '\u0000';
        block0 : switch (tapiNetTextCodingScheme.getCodingGroupType()) {
            case 0: {
                if (tapiNetTextCodingScheme.isbCompressed()) {
                    c = (char)(c | 0x20);
                }
                if (tapiNetTextCodingScheme.isbMsgClassSet()) {
                    c = (char)(c | 0x10);
                    switch (tapiNetTextCodingScheme.getClassType()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            c = (char)(c | '\u0001');
                            break;
                        }
                        case 2: {
                            c = (char)(c | 2);
                            break;
                        }
                        case 3: {
                            c = (char)(c | 3);
                            break;
                        }
                    }
                }
                switch (tapiNetTextCodingScheme.getAlphabetType()) {
                    case 0: {
                        c = (char)(c | '\u0000');
                        break block0;
                    }
                    case 1: {
                        c = (char)(c | 4);
                        break block0;
                    }
                    case 2: {
                        c = (char)(c | 8);
                        break block0;
                    }
                }
                c = (char)(c | 0xC);
                break;
            }
            case 7: {
                c = (char)(c | 0xC0);
                break;
            }
            case 8: {
                c = (char)(c | 0xD0);
                if (tapiNetTextCodingScheme.isbMsgIndActive()) {
                    c = (char)(c | 8);
                }
                switch (tapiNetTextCodingScheme.getWaitingType()) {
                    case 0: {
                        c = (char)(c | '\u0000');
                        break block0;
                    }
                    case 1: {
                        c = (char)(c | '\u0001');
                        break block0;
                    }
                    case 2: {
                        c = (char)(c | 2);
                        break block0;
                    }
                    case 3: {
                        c = (char)(c | 3);
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                c = (char)(c | 0xE0);
                if (tapiNetTextCodingScheme.isbMsgIndActive()) {
                    c = (char)(c | 8);
                }
                switch (tapiNetTextCodingScheme.getWaitingType()) {
                    case 0: {
                        c = (char)(c | '\u0000');
                        break block0;
                    }
                    case 1: {
                        c = (char)(c | '\u0001');
                        break block0;
                    }
                    case 2: {
                        c = (char)(c | 2);
                        break block0;
                    }
                    case 3: {
                        c = (char)(c | 3);
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                c = (char)(c | 0xF0);
                switch (tapiNetTextCodingScheme.getAlphabetType()) {
                    case 0: {
                        c = (char)(c | '\u0000');
                        break;
                    }
                    case 1: {
                        c = (char)(c | 4);
                        break;
                    }
                }
                switch (tapiNetTextCodingScheme.getClassType()) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        c = (char)(c | '\u0001');
                        break block0;
                    }
                    case 2: {
                        c = (char)(c | 2);
                        break block0;
                    }
                    case 3: {
                        c = (char)(c | 3);
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                c = (char)(tapiNetTextCodingScheme.getCodingGroup() << 4 & 0xF0);
                c = (char)(c | tapiNetTextCodingScheme.getCode() & 0xF);
                break;
            }
        }
        return c;
    }

    private boolean SmsUtilEncodeAddrField_sca(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (cArray == null || cArray2 == null) {
            this.logger.warning(DeviceMessages.getString("EncodeMsg.0"));
            return false;
        }
        if (n2 != 5) {
            cArray[this.index++] = n % 2 != 0 ? (char)(n / 2 + 1 + 1) : (char)(n / 2 + 1);
        } else {
            cArray[this.index] = (char)((n * 7 + 7) / 8 * 2);
            if (n * 7 % 8 <= 4) {
                int n4 = this.index;
                cArray[n4] = (char)(cArray[n4] - '\u0001');
            }
            ++this.index;
        }
        cArray[this.index] = 128;
        int n5 = this.index;
        cArray[n5] = (char)(cArray[n5] | (n2 & 7) << 4);
        int n6 = this.index++;
        cArray[n6] = (char)(cArray[n6] | n3 & 0xF);
        if (n2 != 5) {
            char[] cArray3 = new char[n];
            this.SmsUtilConvertDigit2BCD(cArray3, cArray2, n);
            int n7 = this.index;
            this.index = n % 2 != 0 ? (this.index += n / 2 + 1) : (this.index += n / 2);
            int n8 = n7;
            int n9 = 0;
            while (n8 < this.index) {
                cArray[n8] = cArray3[n9];
                ++n8;
                ++n9;
            }
        } else {
            this.SmsUtilPackGSMCode(cArray, cArray2);
        }
        return true;
    }

    private boolean SmsUtilEncodeAddrField_dst(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (cArray == null || cArray2 == null) {
            this.logger.info(DeviceMessages.getString("EncodeMsg.1"));
            return false;
        }
        if (n2 != 5) {
            cArray[this.index++] = (char)n;
        } else {
            cArray[this.index] = (char)((n * 7 + 7) / 8 * 2);
            if (n * 7 % 8 <= 4) {
                int n4 = this.index;
                cArray[n4] = (char)(cArray[n4] - '\u0001');
            }
            ++this.index;
        }
        cArray[this.index] = 128;
        int n5 = this.index;
        cArray[n5] = (char)(cArray[n5] | (n2 & 7) << 4);
        int n6 = this.index++;
        cArray[n6] = (char)(cArray[n6] | n3 & 0xF);
        if (n2 != 5) {
            int n7;
            char[] cArray3 = new char[n];
            for (n7 = 0; n7 < n; ++n7) {
                cArray3[n7] = '\u0000';
            }
            if (!this.SmsUtilConvertDigit2BCD(cArray3, cArray2, n)) {
                return false;
            }
            int n8 = this.index;
            this.index = n % 2 != 0 ? (this.index += n / 2 + 1) : (this.index += n / 2);
            n7 = n8;
            int n9 = 0;
            while (n7 < this.index) {
                cArray[n7] = cArray3[n9];
                ++n7;
                ++n9;
            }
        } else {
            this.SmsUtilPackGSMCode(cArray, cArray2);
        }
        return true;
    }

    private boolean SmsUtilConvertDigit2BCD(char[] cArray, char[] cArray2, long l) {
        if (cArray == null || cArray2 == null) {
            this.logger.warning(DeviceMessages.getString("EncodeMsg.2"));
            return false;
        }
        int n = 0;
        int n2 = 0;
        while ((long)n < l) {
            int n3;
            int n4 = cArray2[n] == '*' ? 10 : (cArray2[n] == '#' ? 11 : (this.toUpperCase(cArray2[n]) == 80 ? 12 : cArray2[n] - 48));
            char c = (char)(n4 & 0xF);
            if (l != (long)(n + 1)) {
                n4 = cArray2[n + 1] == '*' ? 10 : (cArray2[n + 1] == '#' ? 11 : (this.toUpperCase(cArray2[n + 1]) == 80 ? 12 : cArray2[n + 1] - 48));
                n3 = (char)(n4 & 0xF);
            } else {
                n3 = 255;
            }
            cArray[n2] = (char)(n3 << 4 | c);
            int n5 = n2++;
            cArray[n5] = (char)(cArray[n5] & 0xFF);
            n += 2;
        }
        return true;
    }

    private int toUpperCase(int n) {
        return 97 <= n && n <= 122 ? n - 32 : n;
    }
}

