/*
 * Copyright (c) 2014 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef _OAUTH2_H_
#define _OAUTH2_H_

#include <oauth2_manager.h>
#include <oauth2_request.h>
#include <oauth2_response.h>
#include <oauth2_error.h>
#include <oauth2_types.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Tizen OAuth 2.0 Authorization Framework.
 * Refer to <a href="http://tools.ietf.org/html/rfc6749">rfc6749</a> about OAuth 2.0. Also service provider document needs to be referred for using end points and additional parameters.
 */

/**
 * @addtogroup CAPI_OAUTH2_MODULE
 * @{
 */

/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif // _OAUTH2_H_
