/*
 * Copyright (c) 2023 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __TIZEN_MEDIAVISION_MV_POSE_LANDMARK_TYPE_H__
#define __TIZEN_MEDIAVISION_MV_POSE_LANDMARK_TYPE_H__

#include <mv_common.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * @file   mv_pose_landmark_type.h
 * @brief  This file contains the pose landmark handle for Mediavision.
 */

/**
 * @addtogroup CAPI_MEDIA_VISION_POSE_LANDMARK_MODULE
 * @{
 */

/**
 * @brief The pose landmark object handle.
 *
 * @since_tizen 9.0
 */
typedef void *mv_pose_landmark_h;

/**
 * @}
 */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __TIZEN_MEDIAVISION_MV_POSE_LANDMARK_TYPE_H__ */
