#include "$(appName).h"

static void
win_delete_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	component_based_app_exit();
}

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_lower(ad->win);
}

static void
create_base_gui(appdata_s *ad)
{
	/* Window */
	/* Create and initialize elm_win.
	   elm_win is mandatory to manipulate window. */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);
	}

	evas_object_smart_callback_add(ad->win, "delete,request", win_delete_request_cb, NULL);
	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

	/* Conformant */
	/* Create and initialize elm_conformant.
	   elm_conformant is mandatory for base gui to have proper size
	   when indicator or virtual keypad is visible. */
	ad->conform = elm_conformant_add(ad->win);
	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

	/* Label */
	/* Create an actual view of the base gui.
	   Modify this part to change the view. */
	ad->label = elm_label_add(ad->conform);
	elm_object_text_set(ad->label, "<align=center>Hello Tizen</align>");
	evas_object_size_hint_weight_set(ad->label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_content_set(ad->conform, ad->label);

	/* Show window after base gui is set up */
	evas_object_show(ad->win);
}

static Evas_Object* __frame_component_create_cb(
		component_h context,
		void *user_data)
{
	/* Hook to take necessary actions before main event loop starts
	   Initialize UI resources and application's data.	*/
	appdata_s *ad = user_data;

	create_base_gui(ad);

	return ad->win;
}

static void __frame_component_start_cb(
		component_h context,
		app_control_h app_control,
		bool restarted,
		void *user_data)
{
	/* Take necessary actions when frame component becomes start. */
}

static void __frame_component_resume_cb(
		component_h context,
		void *user_data)
{
	/* Take necessary actions when frame component becomes visible. */
}

static void __frame_component_pause_cb(
		component_h context,
		void *user_data)
{
	/* Take necessary actions when frame component becomes invisible. */
}

static void __frame_component_stop_cb(
		component_h context,
		void *user_data)
{
	/* Take necessary actions when frame component becomes stop. */
}

static void __frame_component_destroy_cb(
		component_h context,
		void *user_data)
{
	/* Release all resources. */
}

static void __frame_component_restore_content_cb(
		component_h context,
		bundle *content,
		void *user_data)
{
	/* Take necessary actions when frame component restores content. */
}

static void __frame_component_save_content_cb(
		component_h context,
		bundle *content,
		void *user_data)
{
	/* Take necessary actions when frame component saves content. */
}

static void __frame_component_action_cb(component_h context,
		const char *action, app_control_h app_control,
		void *user_data)
{
	/* Handle the launch request. */
}

static void __frame_component_device_orientation_changed_cb(
		component_h context,
		component_device_orientation_e orientation,
		void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
}

static void __frame_component_language_changed_cb(
		component_h context,
		const char *language,
		void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	elm_language_set(language);
}

static void __frame_component_region_format_changed_cb(
		component_h context,
		const char *region,
		void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void __frame_component_low_battery_cb(
		component_h context,
		component_low_battery_status_e status,
		void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void __frame_component_low_memory_cb(
		component_h context,
		component_low_memory_status_e status,
		void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

static void __frame_component_suspended_state_changed_cb(
		component_h context,
		component_suspended_state_e state,
		void *user_data)
{
	/*APP_EVENT_SUSPENDED_STATE*/
}

component_class_h sample_frame_component_add(component_class_h comp, const char *comp_id, void *user_data)
{
	frame_component_lifecycle_callback_s cb = {
		.create = __frame_component_create_cb,
		.start = __frame_component_start_cb,
		.resume = __frame_component_resume_cb,
		.pause = __frame_component_pause_cb,
		.stop = __frame_component_stop_cb,
		.destroy = __frame_component_destroy_cb,
		.restore_content = __frame_component_restore_content_cb,
		.save_content = __frame_component_save_content_cb,
		.action = __frame_component_action_cb,
		.device_orientation_changed = __frame_component_device_orientation_changed_cb,
		.language_changed = __frame_component_language_changed_cb,
		.region_format_changed = __frame_component_region_format_changed_cb,
		.low_battery = __frame_component_low_battery_cb,
		.low_memory = __frame_component_low_memory_cb,
		.suspended_state_changed = __frame_component_suspended_state_changed_cb
	};

	return component_based_app_add_frame_component(comp,
					comp_id, &cb, user_data);
}
