#include "$(appName).h"

static bool __service_component_create_cb(
		component_h context,
		void *user_data)
{
	/* Hook to take necessary actions before main event loop starts
	   Initialize application's data. */
	return true;
}

static void __service_component_start_command_cb(
		component_h context,
		app_control_h app_control,
		bool restarted,
		void *user_data)
{
	/* Take necessary actions when service component becomes start. */
}

static void __service_component_destroy_cb(
		component_h context,
		void *user_data)
{
	/* Release all resources. */
}

static void __service_component_restore_content_cb(
		component_h context,
		bundle *content,
		void *user_data)
{
	/* Take necessary actions when service component restores content. */
}

static void __service_component_save_content_cb(
		component_h context,
		bundle *content,
		void *user_data)
{
	/* Take necessary actions when service component saves content. */
}

static void __service_component_action_cb(component_h context,
		const char *action, app_control_h app_control,
		void *user_data)
{
	/* Handle the launch request. */
}

static void __service_component_device_orientation_changed_cb(
		component_h context,
		component_device_orientation_e orientation,
		void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
}

static void __service_component_language_changed_cb(
		component_h context,
		const char *language,
		void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
}

static void __service_component_region_format_changed_cb(
		component_h context,
		const char *region,
		void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void __service_component_low_battery_cb(
		component_h context,
		component_low_battery_status_e status,
		void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void __service_component_low_memory_cb(
		component_h context,
		component_low_memory_status_e status,
		void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

static void __service_component_suspended_state_changed_cb(
		component_h context,
		component_suspended_state_e state,
		void *user_data)
{
	/*APP_EVENT_SUSPENDED_STATE*/
}

component_class_h sample_service_component_add(component_class_h comp, const char *comp_id, void *user_data)
{
	service_component_lifecycle_callback_s service_cb = {
		.create = __service_component_create_cb,
		.start_command = __service_component_start_command_cb,
		.destroy = __service_component_destroy_cb,
		.restore_content = __service_component_restore_content_cb,
		.save_content = __service_component_save_content_cb,
		.action = __service_component_action_cb,
		.device_orientation_changed = __service_component_device_orientation_changed_cb,
		.language_changed = __service_component_language_changed_cb,
		.region_format_changed = __service_component_region_format_changed_cb,
		.low_battery = __service_component_low_battery_cb,
		.low_memory = __service_component_low_memory_cb,
		.suspended_state_changed = __service_component_suspended_state_changed_cb
	};

	return component_based_app_add_service_component(comp,
					comp_id, &service_cb, user_data);
}

