/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tpklib.lib.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.lib.Log;
import org.tizen.tpklib.lib.PathUtil;
import org.tizen.tpklib.lib.zip.AbstractZip;

public class ZipLibrary
extends AbstractZip {
    static final int BUFFER = 4096;
    private Log log = TPK.log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zipping(File file, String outFilePath, int permission) throws FileNotFoundException, IOException {
        if (file == null || outFilePath == null) {
            return false;
        }
        File[] zipFileList = file.listFiles();
        File outFile = new File(outFilePath);
        if (outFile.exists()) {
            throw new IOException("Already exist: " + outFilePath);
        }
        FileOutputStream dest = null;
        ZipArchiveOutputStream out = null;
        try {
            dest = new FileOutputStream(outFilePath);
            out = new ZipArchiveOutputStream(dest);
            boolean bl = this.zipping(zipFileList, out, file.getCanonicalPath(), permission);
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zipping(File file, ZipArchiveOutputStream out, String rootPath, int permission) throws IOException {
        FileInputStream fInputStream = null;
        BufferedInputStream bInputStream = null;
        byte[] data = new byte[4096];
        if (file.listFiles() == null) {
            return true;
        }
        if (out == null || rootPath == null) {
            return false;
        }
        ZipArchiveEntry zipEntry = null;
        try {
            for (File f : file.listFiles()) {
                String relativePath = PathUtil.getRelativePath(rootPath, f.getCanonicalPath());
                if (f.isDirectory()) {
                    relativePath = relativePath + File.separator;
                }
                zipEntry = new ZipArchiveEntry(relativePath);
                if (permission == 0) {
                    permission = 493;
                }
                zipEntry.setUnixMode(permission);
                if (f.isDirectory()) {
                    out.putArchiveEntry(zipEntry);
                    out.closeArchiveEntry();
                    this.printAddingMessage(zipEntry);
                    this.zipping(f, out, rootPath, permission);
                    continue;
                }
                out.putArchiveEntry(zipEntry);
                fInputStream = new FileInputStream(f);
                bInputStream = new BufferedInputStream(fInputStream, 4096);
                int readBuf = 0;
                while ((readBuf = bInputStream.read(data)) > 0) {
                    out.write(data, 0, readBuf);
                }
                out.flush();
                this.printAddingMessage(zipEntry);
                if (bInputStream != null) {
                    bInputStream.close();
                }
                if (fInputStream != null) {
                    fInputStream.close();
                }
                if (zipEntry == null) continue;
                out.closeArchiveEntry();
            }
        }
        finally {
            if (bInputStream != null) {
                bInputStream.close();
            }
            if (fInputStream != null) {
                fInputStream.close();
            }
            if (zipEntry != null) {
                try {
                    out.closeArchiveEntry();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zipping(File[] fileList, ZipArchiveOutputStream out, String rootPath, int permission) throws IOException {
        FileInputStream fInputStream = null;
        BufferedInputStream bInputStream = null;
        byte[] data = new byte[4096];
        if (fileList == null) {
            return true;
        }
        if (out == null || rootPath == null) {
            return false;
        }
        ZipArchiveEntry zipEntry = null;
        try {
            for (File f : fileList) {
                String relativePath = PathUtil.getRelativePath(rootPath, f.getCanonicalPath());
                if (f.isDirectory()) {
                    relativePath = relativePath + File.separator;
                }
                zipEntry = new ZipArchiveEntry(relativePath);
                if (permission == 0) {
                    permission = 493;
                }
                zipEntry.setUnixMode(permission);
                if (f.isDirectory()) {
                    out.putArchiveEntry(zipEntry);
                    out.closeArchiveEntry();
                    this.printAddingMessage(zipEntry);
                    this.zipping(f, out, rootPath, permission);
                    continue;
                }
                out.putArchiveEntry(zipEntry);
                fInputStream = new FileInputStream(f);
                bInputStream = new BufferedInputStream(fInputStream, 4096);
                int readBuf = 0;
                while ((readBuf = bInputStream.read(data)) > 0) {
                    out.write(data, 0, readBuf);
                }
                out.flush();
                this.printAddingMessage(zipEntry);
                if (bInputStream != null) {
                    bInputStream.close();
                }
                if (fInputStream != null) {
                    fInputStream.close();
                }
                if (zipEntry == null) continue;
                out.closeArchiveEntry();
            }
        }
        finally {
            if (bInputStream != null) {
                bInputStream.close();
            }
            if (fInputStream != null) {
                fInputStream.close();
            }
            if (zipEntry != null) {
                try {
                    out.closeArchiveEntry();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private void printAddingMessage(ZipArchiveEntry entry) throws IOException {
        if (this.outStream == null || entry == null) {
            return;
        }
        long size = entry.getSize();
        String comment = null;
        comment = entry.isDirectory() ? "directory" : "file";
        this.printStream(entry.getName(), size, comment);
    }
}

