/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;

public class WizardUIMainOptions {
    private static final Logger logger = Log.getLogger(WizardUIMainOptions.class);
    public static boolean noJavaVersionCheck = false;

    public static void loadCmdArgs(String[] args) throws UMException {
        Iterator<String> iter = Arrays.asList(args).iterator();
        while (iter.hasNext()) {
            String arg = iter.next();
            logger.trace("\t" + arg + " option is specified");
            if (arg.equals("-path")) {
                if (iter.hasNext()) {
                    Config.executablePath = iter.next();
                    logger.trace("\tinput path : " + Config.executablePath);
                    continue;
                }
                throw new UMException(ErrorController.ErrorCode.INITIALIZING_FAILED, (Throwable)new UMException(ErrorController.ErrorCode.EXECUTABLE_PATH_REQUIRED));
            }
            if (arg.equals("-noJavaVersionCheck")) {
                noJavaVersionCheck = true;
                continue;
            }
            if (arg.equals("-tm")) {
                try {
                    if (!iter.hasNext()) continue;
                    Config.timer = Integer.valueOf(iter.next().trim());
                }
                catch (Exception e) {
                    Config.timer = 50;
                }
                continue;
            }
            logger.error("Uninstaller do not support '" + arg + "' option");
        }
    }
}

