/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.window;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.window.Window;

public class WindowManager {
    private ArrayList<Window> windows = new ArrayList();
    private List<WindowManager> subManagers;

    public WindowManager() {
    }

    public WindowManager(WindowManager parent) {
        Assert.isNotNull(parent);
        parent.addWindowManager(this);
    }

    public void add(Window window) {
        if (!this.windows.contains(window)) {
            this.windows.add(window);
            window.setWindowManager(this);
        }
    }

    private void addWindowManager(WindowManager wm) {
        if (this.subManagers == null) {
            this.subManagers = new ArrayList<WindowManager>();
        }
        if (!this.subManagers.contains(wm)) {
            this.subManagers.add(wm);
        }
    }

    public boolean close() {
        ArrayList<Window> t = new ArrayList<Window>(this.windows);
        for (Window window : t) {
            boolean closed = window.close();
            if (closed) continue;
            return false;
        }
        if (this.subManagers != null) {
            for (WindowManager wm : this.subManagers) {
                boolean closed = wm.close();
                if (closed) continue;
                return false;
            }
        }
        return true;
    }

    public int getWindowCount() {
        return this.windows.size();
    }

    public Window[] getWindows() {
        Window[] bs = new Window[this.windows.size()];
        this.windows.toArray(bs);
        return bs;
    }

    public final void remove(Window window) {
        if (this.windows.contains(window)) {
            this.windows.remove(window);
            window.setWindowManager(null);
        }
    }
}

