/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IPropertyBag;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebFramePrivate;
import org.eclipse.swt.internal.webkit.IWebOpenPanelResultListener;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebUIDelegate {
    COMObject iWebUIDelegate;
    int refCount = 0;
    String lastHoveredLinkURL;
    Browser browser;
    Point size;
    Point location;
    boolean menuBar = true;
    boolean toolBar = true;
    boolean statusBar = true;
    boolean prompt = true;

    WebUIDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int canTakeFocus(long l, int n, long l2) {
        OS.MoveMemory(l2, new int[]{1}, 4);
        return 0;
    }

    int contextMenuItemsForElement(long l, long l2, long l3, long l4) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (event.doit) {
            Menu menu = this.browser.getMenu();
            if (menu != null && !menu.isDisposed()) {
                if (event.x != point.x || event.y != point.y) {
                    menu.setLocation(event.x, event.y);
                }
                menu.setVisible(true);
            } else {
                OS.MoveMemory(l4, new long[]{l3}, C.PTR_SIZEOF);
                return 0;
            }
        }
        OS.MoveMemory(l4, new long[]{0L}, C.PTR_SIZEOF);
        return 0;
    }

    void createCOMInterfaces() {
        this.iWebUIDelegate = new COMObject(new int[]{2, 0, 0, 3, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 4, 2, 3, 4, 4, 3, 3, 3, 3, 5, 3, 1, 3, 2, 2, 2, 2, 3, 2, 3, 1, 1, 0, 0, 1, 1, 2, 2, 2, 2, 3, 5, 2, 2, 3, 1, 2, 2, 4, 10, 3}){

            public long method0(long[] lArray) {
                return WebUIDelegate.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return WebUIDelegate.this.AddRef();
            }

            public long method2(long[] lArray) {
                return WebUIDelegate.this.Release();
            }

            public long method3(long[] lArray) {
                return WebUIDelegate.this.createWebViewWithRequest(lArray[0], lArray[1], lArray[2]);
            }

            public long method4(long[] lArray) {
                return WebUIDelegate.this.webViewShow(lArray[0]);
            }

            public long method5(long[] lArray) {
                return WebUIDelegate.this.webViewClose(lArray[0]);
            }

            public long method6(long[] lArray) {
                return -2147467263L;
            }

            public long method7(long[] lArray) {
                return -2147467263L;
            }

            public long method8(long[] lArray) {
                return -2147467263L;
            }

            public long method9(long[] lArray) {
                return -2147467263L;
            }

            public long method10(long[] lArray) {
                return WebUIDelegate.this.setStatusText(lArray[0], lArray[1]);
            }

            public long method11(long[] lArray) {
                return -2147467263L;
            }

            public long method12(long[] lArray) {
                return -2147467263L;
            }

            public long method13(long[] lArray) {
                return WebUIDelegate.this.setToolbarsVisible(lArray[0], (int)lArray[1]);
            }

            public long method14(long[] lArray) {
                return -2147467263L;
            }

            public long method15(long[] lArray) {
                return WebUIDelegate.this.setStatusBarVisible(lArray[0], (int)lArray[1]);
            }

            public long method16(long[] lArray) {
                return -2147467263L;
            }

            public long method17(long[] lArray) {
                return -2147467263L;
            }

            public long method18(long[] lArray) {
                return WebUIDelegate.this.setFrame(lArray[0], lArray[1]);
            }

            public long method19(long[] lArray) {
                return -2147467263L;
            }

            public long method20(long[] lArray) {
                return -2147467263L;
            }

            public long method21(long[] lArray) {
                return -2147467263L;
            }

            public long method22(long[] lArray) {
                return WebUIDelegate.this.runJavaScriptAlertPanelWithMessage(lArray[0], lArray[1]);
            }

            public long method23(long[] lArray) {
                return WebUIDelegate.this.runJavaScriptConfirmPanelWithMessage(lArray[0], lArray[1], lArray[2]);
            }

            public long method24(long[] lArray) {
                return WebUIDelegate.this.runJavaScriptTextInputPanelWithPrompt(lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            public long method25(long[] lArray) {
                return WebUIDelegate.this.runBeforeUnloadConfirmPanelWithMessage(lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            public long method26(long[] lArray) {
                return WebUIDelegate.this.runOpenPanelForFileButtonWithResultListener(lArray[0], lArray[1]);
            }

            public long method27(long[] lArray) {
                return WebUIDelegate.this.mouseDidMoveOverElement(lArray[0], lArray[1], (int)lArray[2]);
            }

            public long method28(long[] lArray) {
                return WebUIDelegate.this.contextMenuItemsForElement(lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            public long method29(long[] lArray) {
                return -2147467263L;
            }

            public long method30(long[] lArray) {
                return -2147467263L;
            }

            public long method31(long[] lArray) {
                return -2147467263L;
            }

            public long method32(long[] lArray) {
                return -2147467263L;
            }

            public long method33(long[] lArray) {
                return -2147467263L;
            }

            public long method34(long[] lArray) {
                return -2147467263L;
            }

            public long method35(long[] lArray) {
                return -2147467263L;
            }

            public long method36(long[] lArray) {
                return -2147467263L;
            }

            public long method37(long[] lArray) {
                return -2147467263L;
            }

            public long method38(long[] lArray) {
                return -2147467263L;
            }

            public long method39(long[] lArray) {
                return -2147467263L;
            }

            public long method40(long[] lArray) {
                return -2147467263L;
            }

            public long method41(long[] lArray) {
                return -2147467263L;
            }

            public long method42(long[] lArray) {
                return WebUIDelegate.this.canTakeFocus(lArray[0], (int)lArray[1], lArray[2]);
            }

            public long method43(long[] lArray) {
                return WebUIDelegate.this.takeFocus(lArray[0], (int)lArray[1]);
            }

            public long method44(long[] lArray) {
                return -2147467263L;
            }

            public long method45(long[] lArray) {
                return 0L;
            }

            public long method46(long[] lArray) {
                return -2147467263L;
            }

            public long method47(long[] lArray) {
                return -2147467263L;
            }

            public long method48(long[] lArray) {
                return -2147467263L;
            }

            public long method49(long[] lArray) {
                return -2147467263L;
            }

            public long method50(long[] lArray) {
                return -2147467263L;
            }

            public long method51(long[] lArray) {
                return WebUIDelegate.this.printFrame(lArray[0], lArray[1]);
            }

            public long method52(long[] lArray) {
                return -2147467263L;
            }

            public long method53(long[] lArray) {
                return -2147467263L;
            }

            public long method54(long[] lArray) {
                return -2147467263L;
            }

            public long method55(long[] lArray) {
                return -2147467263L;
            }

            public long method56(long[] lArray) {
                return -2147467263L;
            }

            public long method57(long[] lArray) {
                return -2147467263L;
            }

            public long method58(long[] lArray) {
                return -2147467263L;
            }

            public long method59(long[] lArray) {
                return -2147467263L;
            }

            public long method60(long[] lArray) {
                return -2147467263L;
            }

            public long method61(long[] lArray) {
                return -2147467263L;
            }

            public long method62(long[] lArray) {
                return WebUIDelegate.this.setMenuBarVisible(lArray[0], (int)lArray[1]);
            }

            public long method63(long[] lArray) {
                return -2147467263L;
            }

            public long method64(long[] lArray) {
                return -2147467263L;
            }

            public long method65(long[] lArray) {
                return -2147467263L;
            }
        };
    }

    int createWebViewWithRequest(long l, long l2, long l3) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        OpenWindowListener[] openWindowListenerArray = this.browser.webBrowser.openWindowListeners;
        for (int i = 0; i < openWindowListenerArray.length; ++i) {
            openWindowListenerArray[i].open(windowEvent);
        }
        IWebView iWebView = null;
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            iWebView = ((WebKit)((Browser)widget).webBrowser).webView;
            OS.MoveMemory(l3, new long[]{iWebView.getAddress()}, OS.PTR_SIZEOF);
            if (l2 != 0L) {
                IWebURLRequest iWebURLRequest = new IWebURLRequest(l2);
                long[] lArray = new long[1];
                int n = iWebURLRequest.URL(lArray);
                if (n != 0 || lArray[0] == 0L) {
                    return 0;
                }
                String string = WebKit.extractBSTR(lArray[0]);
                COM.SysFreeString(lArray[0]);
                if (string.length() != 0) {
                    lArray[0] = 0L;
                    n = iWebView.mainFrame(lArray);
                    if (n != 0 || lArray[0] == 0L) {
                        return 0;
                    }
                    IWebFrame iWebFrame = new IWebFrame(lArray[0]);
                    iWebFrame.loadRequest(iWebURLRequest.getAddress());
                    iWebFrame.Release();
                }
            }
            return 0;
        }
        return -2147467263;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebUIDelegate != null) {
            this.iWebUIDelegate.dispose();
            this.iWebUIDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebUIDelegate.getAddress();
    }

    int mouseDidMoveOverElement(long l, long l2, int n) {
        long l3;
        long l4;
        if (l2 == 0L) {
            return 0;
        }
        IPropertyBag iPropertyBag = new IPropertyBag(l2);
        long l5 = WebKit.createBSTR("WebElementLinkURLKey");
        int n2 = iPropertyBag.Read(l5, l4 = OS.HeapAlloc(l3 = OS.GetProcessHeap(), 8, VARIANT.sizeof), null);
        if (n2 != 0 || l4 == 0L) {
            return 0;
        }
        String string = null;
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l4, VARIANT.sizeof);
        if (vARIANT.vt == 8) {
            string = WebKit.extractBSTR(vARIANT.lVal);
        }
        OS.HeapFree(l3, 0, l4);
        StatusTextListener[] statusTextListenerArray = this.browser.webBrowser.statusTextListeners;
        if (string == null || string.length() == 0) {
            if (this.lastHoveredLinkURL == null) {
                return 0;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = "";
            for (int i = 0; i < statusTextListenerArray.length; ++i) {
                statusTextListenerArray[i].changed(statusTextEvent);
            }
            return 0;
        }
        if (string.equals(this.lastHoveredLinkURL)) {
            return 0;
        }
        this.lastHoveredLinkURL = string;
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = string;
        for (int i = 0; i < statusTextListenerArray.length; ++i) {
            statusTextListenerArray[i].changed(statusTextEvent);
        }
        return 0;
    }

    int printFrame(long l, long l2) {
        int n;
        Object object;
        IWebFrame iWebFrame = new IWebFrame(l2);
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = PRINTDLG.sizeof;
        pRINTDLG.Flags = 256;
        if (!OS.PrintDlg(pRINTDLG)) {
            return 0;
        }
        long l3 = pRINTDLG.hDC;
        long[] lArray = new long[1];
        int n2 = iWebFrame.QueryInterface(WebKit_win32.IID_IWebFramePrivate, lArray);
        if (n2 != 0 || lArray[0] == 0L) {
            return 0;
        }
        IWebFramePrivate iWebFramePrivate = new IWebFramePrivate(lArray[0]);
        iWebFramePrivate.setInPrintingMode(1, l3);
        int[] nArray = new int[1];
        n2 = iWebFramePrivate.getPrintedPageCount(l3, nArray);
        if (n2 != 0 || nArray[0] == 0) {
            iWebFramePrivate.Release();
            return 0;
        }
        int n3 = nArray[0];
        String string = null;
        lArray[0] = 0L;
        n2 = iWebFrame.dataSource(lArray);
        if (n2 == 0 && lArray[0] != 0L) {
            object = new IWebDataSource(lArray[0]);
            lArray[0] = 0L;
            n2 = ((IWebDataSource)object).pageTitle(lArray);
            ((IUnknown)object).Release();
            if (n2 == 0 && lArray[0] != 0L) {
                string = WebKit.extractBSTR(lArray[0]);
                COM.SysFreeString(lArray[0]);
            }
        }
        object = new DOCINFO();
        ((DOCINFO)object).cbSize = DOCINFO.sizeof;
        long l4 = OS.GetProcessHeap();
        long l5 = 0L;
        if (string != null && string.length() != 0) {
            TCHAR tCHAR = new TCHAR(0, string, true);
            n = tCHAR.length() * TCHAR.sizeof;
            l5 = OS.HeapAlloc(l4, 8, n);
            OS.MoveMemory(l5, tCHAR, n);
            ((DOCINFO)object).lpszDocName = l5;
        }
        int n4 = OS.StartDoc(l3, (DOCINFO)object);
        if (l5 != 0L) {
            OS.HeapFree(l4, 0, l5);
        }
        if (n4 >= 0) {
            for (n = 0; n < n3; ++n) {
                OS.StartPage(l3);
                iWebFramePrivate.spoolPages(l3, n, n, null);
                OS.EndPage(l3);
            }
            iWebFramePrivate.setInPrintingMode(0, l3);
            OS.EndDoc(l3);
        }
        iWebFramePrivate.Release();
        return 0;
    }

    int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(l2, new long[]{this.iWebUIDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebUIDelegate)) {
            COM.MoveMemory(l2, new long[]{this.iWebUIDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(l2, new long[]{0L}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int runBeforeUnloadConfirmPanelWithMessage(long l, long l2, long l3, long l4) {
        if (!this.prompt) {
            return 0;
        }
        Shell shell = this.browser.getShell();
        String string = WebKit.extractBSTR(l2);
        StringBuffer stringBuffer = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        stringBuffer.append("\n\n");
        stringBuffer.append(string);
        stringBuffer.append("\n\n");
        stringBuffer.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox messageBox = new MessageBox(shell, 292);
        messageBox.setMessage(stringBuffer.toString());
        int[] nArray = new int[]{messageBox.open() == 32 ? 1 : 0};
        OS.MoveMemory(l4, nArray, 4);
        return 0;
    }

    int runJavaScriptAlertPanelWithMessage(long l, long l2) {
        String string = WebKit.extractBSTR(l2);
        this.showAlertMessage("Javascript", string);
        return 0;
    }

    int runJavaScriptConfirmPanelWithMessage(long l, long l2, long l3) {
        String string = WebKit.extractBSTR(l2);
        int[] nArray = new int[]{this.showConfirmPanel("Javascript", string) == 32 ? 1 : 0};
        OS.MoveMemory(l3, nArray, 4);
        return 0;
    }

    int runJavaScriptTextInputPanelWithPrompt(long l, long l2, long l3, long l4) {
        String string = WebKit.extractBSTR(l2);
        String string2 = WebKit.extractBSTR(l3);
        String string3 = this.showTextPrompter("Javascript", string, string2);
        long[] lArray = new long[1];
        if (string3 != null) {
            lArray[0] = WebKit.createBSTR(string3);
        }
        OS.MoveMemory(l4, lArray, C.PTR_SIZEOF);
        return 0;
    }

    int runOpenPanelForFileButtonWithResultListener(long l, long l2) {
        Shell shell = this.browser.getShell();
        FileDialog fileDialog = new FileDialog(shell, 0);
        String string = fileDialog.open();
        IWebOpenPanelResultListener iWebOpenPanelResultListener = new IWebOpenPanelResultListener(l2);
        if (string == null) {
            iWebOpenPanelResultListener.cancel();
        } else {
            iWebOpenPanelResultListener.chooseFilename(WebKit.createBSTR(string));
        }
        return 0;
    }

    int setFrame(long l, long l2) {
        RECT rECT = new RECT();
        COM.MoveMemory(rECT, l2, RECT.sizeof);
        this.location = this.browser.getDisplay().map(this.browser, null, rECT.left, rECT.top);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        if (n2 < 0 || n < 0 || n == 0 && n2 == 0) {
            return 0;
        }
        this.size = new Point(n, n2);
        return 0;
    }

    int setMenuBarVisible(long l, int n) {
        this.menuBar = n == 1;
        return 0;
    }

    int setStatusBarVisible(long l, int n) {
        this.statusBar = n == 1;
        return 0;
    }

    int setStatusText(long l, long l2) {
        String string = WebKit.extractBSTR(l2);
        if (string.length() == 0) {
            return 0;
        }
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = string;
        StatusTextListener[] statusTextListenerArray = this.browser.webBrowser.statusTextListeners;
        for (int i = 0; i < statusTextListenerArray.length; ++i) {
            statusTextListenerArray[i].changed(statusTextEvent);
        }
        return 0;
    }

    int setToolbarsVisible(long l, int n) {
        this.toolBar = n == 1;
        return 0;
    }

    void showAlertMessage(String string, String string2) {
        Shell shell = this.browser.getShell();
        final Shell shell2 = new Shell(shell, 67680);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        shell2.setLayout(gridLayout);
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        Image image = shell2.getDisplay().getSystemImage(8);
        label.setImage(image);
        label = new Label(shell2, 64);
        label.setText(string2);
        Monitor monitor = shell.getMonitor();
        int n = monitor.getBounds().width * 2 / 3;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = Math.min(n2, n);
        label.setLayoutData(gridData);
        Button button = new Button(shell2, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        n2 = button.computeSize((int)-1, (int)-1).x;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 0x1000000;
        gridData2.verticalAlignment = 0x1000000;
        gridData2.horizontalSpan = 2;
        gridData2.widthHint = Math.max(n2, 75);
        button.setLayoutData(gridData2);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n3 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n4 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n3, n4);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    int showConfirmPanel(String string, String string2) {
        Shell shell = this.browser.getShell();
        final Shell shell2 = new Shell(shell, 67680);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        shell2.setLayout(gridLayout);
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        Image image = shell2.getDisplay().getSystemImage(4);
        label.setImage(image);
        label.setLayoutData(new GridData());
        label = new Label(shell2, 64);
        label.setText(string2);
        Monitor monitor = shell.getMonitor();
        int n = monitor.getBounds().width * 2 / 3;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = Math.min(n2, n);
        label.setLayoutData(gridData);
        Composite composite = new Composite(shell2, 0);
        gridData = new GridData(0x1000000, 0x1000000, true, true, 2, 1);
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(2, true));
        Button button = new Button(composite, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 0x1000000;
        gridData2.verticalAlignment = 0x1000000;
        button.setLayoutData(gridData2);
        Button button2 = new Button(composite, 8);
        button2.setText(SWT.getMessage("SWT_Cancel"));
        button2.setLayoutData(gridData2);
        n2 = button2.computeSize((int)-1, (int)-1).x;
        gridData2.widthHint = Math.max(n2, 75);
        final int[] nArray = new int[1];
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                nArray[0] = 32;
                shell2.dispose();
            }
        });
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                nArray[0] = 256;
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n3 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n4 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n3, n4);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return nArray[0];
    }

    String showTextPrompter(String string, String string2, String string3) {
        Shell shell = this.browser.getShell();
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        label.setLayoutData(new GridData(768));
        label.setText(string2);
        final Text text = new Text(shell2, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        text.setLayoutData(gridData);
        text.setText(string3);
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(2, true));
        composite.setLayoutData(new GridData(64));
        Button button = new Button(composite, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        button.setLayoutData(new GridData(768));
        final String[] stringArray = new String[1];
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                stringArray[0] = text.getText();
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(SWT.getMessage("SWT_Cancel"));
        button2.setLayoutData(new GridData(768));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n2 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n, n2);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return stringArray[0];
    }

    int takeFocus(long l, int n) {
        int n2 = n == 0 ? 8 : 16;
        ((WebKit)this.browser.webBrowser).traverseOut = true;
        this.browser.traverse(n2);
        return 0;
    }

    int webViewClose(long l) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        CloseWindowListener[] closeWindowListenerArray = this.browser.webBrowser.closeWindowListeners;
        for (int i = 0; i < closeWindowListenerArray.length; ++i) {
            closeWindowListenerArray[i].close(windowEvent);
        }
        this.browser.dispose();
        return 0;
    }

    int webViewFrame(long l, long l2) {
        RECT rECT = new RECT();
        OS.MoveMemory(l2, rECT, RECT.sizeof);
        return 0;
    }

    int webViewShow(long l) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (this.location != null) {
            windowEvent.location = this.location;
        }
        if (this.size != null) {
            windowEvent.size = this.size;
        }
        windowEvent.addressBar = this.toolBar;
        windowEvent.menuBar = this.menuBar;
        windowEvent.statusBar = this.statusBar;
        windowEvent.toolBar = this.toolBar;
        VisibilityWindowListener[] visibilityWindowListenerArray = this.browser.webBrowser.visibilityWindowListeners;
        for (int i = 0; i < visibilityWindowListenerArray.length; ++i) {
            visibilityWindowListenerArray[i].show(windowEvent);
        }
        this.location = null;
        this.size = null;
        return 0;
    }
}

