/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.model;

import java.util.Vector;
import org.tizen.tizenunittest.gtest.model.ITestComposite;
import org.tizen.tizenunittest.gtest.model.NotifyEvent;
import org.tizen.tizenunittest.gtest.model.TestElement;
import org.tizen.tizenunittest.gtest.model.TestStatus;
import org.tizen.tizenunittest.gtest.model.listener.ITestCompositeListener;
import org.tizen.tizenunittest.gtest.model.listener.ITestElementListener;

public class TestSuite
extends TestElement
implements ITestComposite,
ITestElementListener {
    private String name = "";
    private ITestComposite parent;
    private int totalTests = 0;
    private int success = 0;
    private int failure = 0;
    private int abnormal = 0;
    private int error = 0;
    private TestStatus status;
    private Vector<TestElement> cases = new Vector();
    private Vector<ITestCompositeListener> listeners = new Vector();

    public TestSuite(String string, int n, TestStatus testStatus) {
        this.name = string;
        this.totalTests = n;
        this.status = testStatus;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TestStatus getStatus() {
        return this.status;
    }

    protected void endTest(TestElement testElement) {
        switch (testElement.getStatus()) {
            case success: {
                ++this.success;
                break;
            }
            case failure: {
                ++this.failure;
                break;
            }
            case abnormal: {
                ++this.abnormal;
                break;
            }
            case error: {
                ++this.error;
            }
        }
        this.notifyListeners(new NotifyEvent(NotifyEvent.EventType.testFinished, testElement));
    }

    private void setEndStatus() {
        if (this.cases.size() == 0) {
            this.status = TestStatus.success;
        } else {
            for (TestElement testElement : this.cases) {
                if (this.status.ordinal() >= testElement.getStatus().ordinal()) continue;
                this.status = testElement.getStatus();
            }
        }
    }

    @Override
    public int getAbnormalDefects() {
        return this.abnormal;
    }

    @Override
    public int getFailure() {
        return this.failure;
    }

    @Override
    public int getSuccess() {
        return this.success;
    }

    @Override
    public int getTotalTests() {
        return this.totalTests;
    }

    @Override
    public boolean hasManagedErrorOrFailure() {
        return this.failure + this.abnormal + this.error > 0;
    }

    @Override
    public int getRun() {
        return this.success + this.failure + this.abnormal + this.error;
    }

    public String toString() {
        return this.getName();
    }

    public void end() {
        this.setEndStatus();
        this.notifyListeners(new NotifyEvent(NotifyEvent.EventType.suiteFinished, this));
    }

    @Override
    public void addTestElement(TestElement testElement) {
        this.cases.add(testElement);
        testElement.setParent(this);
        testElement.addTestElementListener(this);
        for (ITestCompositeListener iTestCompositeListener : this.listeners) {
            iTestCompositeListener.newTestElement(this, testElement);
        }
    }

    public Vector<TestElement> getElements() {
        return this.cases;
    }

    @Override
    public ITestComposite getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITestComposite iTestComposite) {
        this.parent = iTestComposite;
    }

    @Override
    public void modelChanged(TestElement testElement, NotifyEvent notifyEvent) {
        if (notifyEvent.getType() == NotifyEvent.EventType.testFinished) {
            this.endTest(testElement);
        }
    }

    @Override
    public void addListener(ITestCompositeListener iTestCompositeListener) {
        if (!this.listeners.contains(iTestCompositeListener)) {
            this.listeners.add(iTestCompositeListener);
        }
    }

    @Override
    public void removeListener(ITestCompositeListener iTestCompositeListener) {
        this.listeners.remove(iTestCompositeListener);
    }
}

