/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.model;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunch;
import org.tizen.tizenunittest.gtest.model.ITestComposite;
import org.tizen.tizenunittest.gtest.model.TestCase;
import org.tizen.tizenunittest.gtest.model.TestFailure;
import org.tizen.tizenunittest.gtest.model.TestResult;
import org.tizen.tizenunittest.gtest.model.TestSession;
import org.tizen.tizenunittest.gtest.model.TestStatus;
import org.tizen.tizenunittest.gtest.model.TestSuite;
import org.tizen.tizenunittest.gtest.model.listener.ISessionListener;

public class CuteModel {
    private Vector<ISessionListener> sessionListeners = new Vector();
    private ITestComposite currentParent;
    private TestSession session;

    public void startSession(ILaunch iLaunch) {
        this.session = new TestSession(iLaunch);
        this.currentParent = this.session;
        this.notifyListenerSessionStart(this.session);
    }

    public void startSuite(TestSuite testSuite) {
        this.currentParent.addTestElement(testSuite);
        this.currentParent = testSuite;
    }

    public void addTest(TestCase testCase) {
        if (this.currentParent != null) {
            this.currentParent.addTestElement(testCase);
        }
    }

    public void endCurrentTestCase(IFile iFile, int n, String string, TestStatus testStatus, TestCase testCase) {
        TestResult testResult;
        switch (testStatus) {
            case failure: {
                testResult = new TestFailure(string);
                break;
            }
            default: {
                testResult = new TestResult(string);
            }
        }
        testCase.endTest(iFile, n, testResult, testStatus);
    }

    public void endSuite() {
        if (this.currentParent instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)this.currentParent;
            testSuite.end();
            this.currentParent = testSuite.getParent();
        }
    }

    public void endSession() {
        if (this.currentParent instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)this.currentParent;
            testSuite.end();
        }
        this.notifyListenerSessionEnd(this.session);
    }

    public void addListener(ISessionListener iSessionListener) {
        if (!this.sessionListeners.contains(iSessionListener)) {
            this.sessionListeners.add(iSessionListener);
        }
    }

    public void removeListener(ISessionListener iSessionListener) {
        this.sessionListeners.remove(iSessionListener);
    }

    private void notifyListenerSessionStart(TestSession testSession) {
        for (ISessionListener iSessionListener : this.sessionListeners) {
            iSessionListener.sessionStarted(testSession);
        }
    }

    private void notifyListenerSessionEnd(TestSession testSession) {
        for (ISessionListener iSessionListener : this.sessionListeners) {
            iSessionListener.sessionFinished(testSession);
        }
    }

    public TestSession getSession() {
        return this.session;
    }
}

