/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.resultview;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.model.ITestComposite;
import org.tizen.tizenunittest.gtest.model.NotifyEvent;
import org.tizen.tizenunittest.gtest.model.TestElement;
import org.tizen.tizenunittest.gtest.model.TestSession;
import org.tizen.tizenunittest.gtest.model.listener.ISessionListener;
import org.tizen.tizenunittest.gtest.model.listener.ITestCompositeListener;
import org.tizen.tizenunittest.gtest.model.listener.ITestElementListener;

public class CounterPanel
extends Composite
implements ITestElementListener,
ISessionListener,
ITestCompositeListener {
    private Label runLabel = null;
    private Label runText = null;
    private Image abnormalDefectImage = UnitTestPlugin.getImageDescriptor("obj16/abnormal.png").createImage();
    private Image failedImage = UnitTestPlugin.getImageDescriptor("obj16/failed.png").createImage();
    private Label abnormalDefectImageLabel = null;
    private Label abnormalDefectLabel = null;
    private Label abnormalDefectText = null;
    private Label failedImageLabel = null;
    private Label failedLabel = null;
    private Label failedText = null;
    private TestSession session;
    private int total;

    public CounterPanel(Composite composite, int n) {
        super(composite, n);
        UnitTestPlugin.getModel().addListener(this);
        this.initialize();
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalIndent = 7;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = false;
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalAlignment = 3;
        GridData gridData4 = new GridData();
        gridData4.grabExcessHorizontalSpace = false;
        gridData4.horizontalIndent = 7;
        GridData gridData5 = new GridData();
        gridData5.grabExcessHorizontalSpace = false;
        GridData gridData6 = new GridData();
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.horizontalAlignment = 3;
        GridData gridData7 = new GridData();
        gridData7.grabExcessHorizontalSpace = false;
        gridData7.horizontalIndent = 7;
        GridData gridData8 = new GridData();
        gridData8.grabExcessHorizontalSpace = false;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        this.runLabel = new Label((Composite)this, 0);
        this.runLabel.setText(UnitTestMessages.RESULTVIEW_LABEL_RUNS);
        this.runLabel.setLayoutData((Object)gridData8);
        this.runText = new Label((Composite)this, 8);
        this.runText.setText("0/0");
        this.runText.setLayoutData((Object)gridData7);
        this.abnormalDefectImageLabel = new Label((Composite)this, 0);
        this.abnormalDefectImage.setBackground(this.abnormalDefectImageLabel.getBackground());
        this.abnormalDefectImageLabel.setImage(this.abnormalDefectImage);
        this.abnormalDefectImageLabel.setLayoutData((Object)gridData6);
        this.abnormalDefectLabel = new Label((Composite)this, 0);
        this.abnormalDefectLabel.setText(UnitTestMessages.RESULTVIEW_LABEL_DEFACT);
        this.abnormalDefectLabel.setLayoutData((Object)gridData5);
        this.abnormalDefectText = new Label((Composite)this, 8);
        this.abnormalDefectText.setText("0");
        this.abnormalDefectText.setLayoutData((Object)gridData4);
        this.failedImageLabel = new Label((Composite)this, 0);
        this.failedImage.setBackground(this.failedImageLabel.getBackground());
        this.failedImageLabel.setImage(this.failedImage);
        this.failedImageLabel.setLayoutData((Object)gridData3);
        this.failedLabel = new Label((Composite)this, 0);
        this.failedLabel.setText(UnitTestMessages.RESULTVIEW_LABEL_FAIL);
        this.failedLabel.setLayoutData((Object)gridData2);
        this.failedText = new Label((Composite)this, 8);
        this.failedText.setText("0");
        this.failedText.setLayoutData((Object)gridData);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CounterPanel.this.disposeIcons();
                UnitTestPlugin.getModel().removeListener(CounterPanel.this);
            }
        });
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(342, 30));
    }

    private void disposeIcons() {
        this.abnormalDefectImage.dispose();
        this.failedImage.dispose();
    }

    public void setTotal(int n) {
        this.total = n;
        this.layout();
    }

    public void setRun(int n) {
        this.runText.setText(String.valueOf(Integer.toString(n)) + "/" + Integer.toString(this.total));
        this.runText.pack(true);
        this.layout();
        this.redraw();
    }

    public void setAbnormalDefects(int n) {
        this.abnormalDefectText.setText(Integer.toString(n));
        this.abnormalDefectText.pack(true);
        this.layout();
        this.redraw();
    }

    public void setFailures(int n) {
        this.failedText.setText(Integer.toString(n));
        this.failedText.pack(true);
        this.redraw();
    }

    public void reset(TestSession testSession) {
        this.updateNumbers();
    }

    private void updateNumbers() {
        this.setTotal(this.session.getTotalTests());
        this.setRun(this.session.getRun());
        this.setFailures(this.session.getFailure());
        this.setAbnormalDefects(this.session.getAbnormalDefects());
    }

    @Override
    public void modelChanged(TestElement testElement, NotifyEvent notifyEvent) {
        UpdateCounterPanelJob updateCounterPanelJob = new UpdateCounterPanelJob("Update CounterPanel Job");
        updateCounterPanelJob.schedule();
    }

    @Override
    public void newTestElement(ITestComposite iTestComposite, TestElement testElement) {
        UpdateCounterPanelJob updateCounterPanelJob = new UpdateCounterPanelJob("Update CounterPanel Job");
        testElement.addTestElementListener(this);
        updateCounterPanelJob.schedule();
    }

    @Override
    public void sessionStarted(TestSession testSession) {
        this.session = testSession;
        testSession.addListener(this);
        UpdateCounterPanelJob updateCounterPanelJob = new UpdateCounterPanelJob("Update CounterPanel Job");
        updateCounterPanelJob.schedule();
    }

    @Override
    public void sessionFinished(TestSession testSession) {
    }

    private final class UpdateCounterPanelJob
    extends UIJob {
        private UpdateCounterPanelJob(String string) {
            super(string);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            CounterPanel.this.updateNumbers();
            return new Status(0, "org.tizen.tizenunittest.gtest", 0, "OK", null);
        }
    }
}

