/*
 * Decompiled with CFR 0.152.
 */
package json;

import json.text.JsonScanner;
import json.util.JsonColorProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JsonEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "Json";
    private static JsonEditorPlugin fgInstance;
    private JsonScanner fJsonScanner;
    private JsonColorProvider fColorProvider;
    public static final String SPACES_FOR_TABS = "spaces_for_tabs";
    public static final String NUM_SPACES = "num_spaces";
    public static final String EDITOR_MATCHING_BRACKETS = "matchingBrackets";
    public static final String EDITOR_MATCHING_BRACKETS_COLOR = "matchingBracketsColor";

    public JsonEditorPlugin() {
        fgInstance = this;
    }

    public static JsonEditorPlugin getDefault() {
        return fgInstance;
    }

    public RuleBasedScanner getJsonScanner() {
        if (this.fJsonScanner == null) {
            this.fJsonScanner = new JsonScanner(this.getColorProvider());
        }
        return this.fJsonScanner;
    }

    public JsonColorProvider getColorProvider() {
        if (this.fColorProvider == null) {
            this.fColorProvider = new JsonColorProvider();
        }
        return this.fColorProvider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        fgInstance = this;
    }

    public void stop(BundleContext context) throws Exception {
        fgInstance = null;
        super.stop(context);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return JsonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IPreferenceStore getJsonPreferenceStore() {
        IPreferenceStore store = JsonEditorPlugin.getDefault().getPreferenceStore();
        JsonColorProvider provider = JsonEditorPlugin.getDefault().getColorProvider();
        store.setDefault(SPACES_FOR_TABS, true);
        store.setDefault(NUM_SPACES, 4);
        store.setDefault(EDITOR_MATCHING_BRACKETS, true);
        store.setDefault(EDITOR_MATCHING_BRACKETS_COLOR, provider.getColor(JsonColorProvider.STRING).toString());
        return store;
    }
}

