/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.page;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.dialog.LocaleDialog;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.config.schema.model.Description;
import org.tizen.web.config.schema.model.License;
import org.tizen.web.config.schema.model.Name;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.localization.DescriptionContentProvider;
import org.tizen.web.editor.configuration.localization.DescriptionEditingSupport;
import org.tizen.web.editor.configuration.localization.DescriptionLabelProvider;
import org.tizen.web.editor.configuration.localization.LicenseContentProvider;
import org.tizen.web.editor.configuration.localization.LicenseDialog;
import org.tizen.web.editor.configuration.localization.LicenseEditingSupport;
import org.tizen.web.editor.configuration.localization.LicenseLabelProvider;
import org.tizen.web.editor.configuration.localization.NameContentProvider;
import org.tizen.web.editor.configuration.localization.NameEditingSupport;
import org.tizen.web.editor.configuration.localization.NameLabelProvider;
import org.tizen.web.editor.configuration.page.AbstractFormPage;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class LocalizationPage
extends AbstractFormPage {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String LocalizationPage_ID = "Localization";
    private List<Name> internalLocaledNames;
    private TableViewer nameViewer;
    private NameEditingSupport nameLangEditingSupport;
    private NameEditingSupport nameContentEditingSupport;
    private ImageButton nameAddBtn;
    private ImageButton nameEditBtn;
    private ImageButton nameRemoveBtn;
    private SelectionListener nameAddBtnSelectionListener;
    private SelectionListener nameEditBtnSelectionListener;
    private SelectionListener nameRemoveBtnSelectionListener;
    private IDoubleClickListener nameViewerDoubleClickListener;
    private ISelectionChangedListener nameViewerSelectionChangedListener;
    private List<Description> internalLocaledDescriptions;
    private TableViewer descriptionViewer;
    private DescriptionEditingSupport descriptionLangEditingSupport;
    private DescriptionEditingSupport descriptionContentEditingSupport;
    private ImageButton descriptionAddBtn;
    private ImageButton descriptionEditBtn;
    private ImageButton descriptionRemoveBtn;
    private SelectionListener descriptionAddBtnSelectionListener;
    private SelectionListener descriptionEditBtnSelectionListener;
    private SelectionListener descriptionRemoveBtnSelectionListener;
    private IDoubleClickListener descriptionViewerDoubleClickListener;
    private ISelectionChangedListener descriptionViewerSelectionChangedListener;
    private List<License> internalLocaledLicenses;
    private TableViewer licenseViewer;
    private LicenseEditingSupport licenseLangEditingSupport;
    private LicenseEditingSupport licenseContentEditingSupport;
    private LicenseEditingSupport licenseHrefEditingSupport;
    private ImageButton licenseAddBtn;
    private ImageButton licenseEditBtn;
    private ImageButton licenseRemoveBtn;
    private SelectionListener licenseAddBtnSelectionListener;
    private SelectionListener licenseEditBtnSelectionListener;
    private SelectionListener licenseRemoveBtnSelectionListener;
    private IDoubleClickListener licenseViewerDoubleClickListener;
    private ISelectionChangedListener licenseViewerSelectionChangedListener;
    private AbstractChangeListener changeListener;

    public LocalizationPage(ConfigurationEditor editor) {
        super(editor, LocalizationPage_ID, Messages.LocalizationPage_ID);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createForm(Messages.LocalizationPage_ID, "icons/ConfigurationEditor/40_title_localization.png");
        Composite page = this.createPage(this.body);
        Composite section = this.editorToolkit.createSection(page, Messages.LocalizationPage_SectionLabel, Messages.LocalizationPage_SectionDescription);
        this.createNameControl(section);
        this.createDescriptionControl(section);
        this.createLicenseControl(section);
        ((Section)section.getParent()).setExpanded(true);
        this.addListener();
    }

    protected void createNameControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Composite nameComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(2, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        nameComposite.setLayout((Layout)grid);
        nameComposite.setLayoutData((Object)new GridData(768));
        Label nameLabel = this.editorToolkit.createBoldLabel(nameComposite, Messages.LocalizationPage_NameGroupLabel, 64);
        nameLabel.setToolTipText(Messages.LocalizationPage_NameGroupTooltip);
        GridData data = new GridData(1, 1, true, false);
        nameLabel.setLayoutData((Object)data);
        Composite tableBtns = this.editorToolkit.createComposite(nameComposite);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        this.nameAddBtn = this.editorToolkit.createAddButton(tableBtns);
        this.nameEditBtn = this.editorToolkit.createEditButton(tableBtns);
        this.nameRemoveBtn = this.editorToolkit.createRemoveButton(tableBtns);
        this.nameAddBtn.setEnabled(false);
        this.nameEditBtn.setEnabled(false);
        this.nameRemoveBtn.setEnabled(false);
        this.nameViewer = new TableViewer(base, 68354);
        Table table = this.nameViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(768);
        data.heightHint = 124;
        table.setLayoutData((Object)data);
        TableViewerColumn langColumn = new TableViewerColumn(this.nameViewer, 0);
        langColumn.getColumn().setText(Messages.ATTRIBUTE_XML_LANG);
        langColumn.getColumn().setToolTipText(Messages.ATTRIBUTE_XML_LANG_TOOLTIP);
        langColumn.getColumn().pack();
        this.nameLangEditingSupport = new NameEditingSupport((ColumnViewer)this.nameViewer, 0);
        langColumn.setEditingSupport((EditingSupport)this.nameLangEditingSupport);
        TableViewerColumn contentColumn = new TableViewerColumn(this.nameViewer, 0);
        contentColumn.getColumn().setText(Messages.LocalizationPage_NameLabel);
        contentColumn.getColumn().setToolTipText(Messages.LocalizationPage_NameTooltip);
        contentColumn.getColumn().pack();
        this.nameContentEditingSupport = new NameEditingSupport((ColumnViewer)this.nameViewer, 1);
        contentColumn.setEditingSupport((EditingSupport)this.nameContentEditingSupport);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7));
        this.nameViewer.getTable().setLayout((Layout)tableLayout);
        NameContentProvider nameCP = new NameContentProvider();
        NameLabelProvider nameLP = new NameLabelProvider();
        this.nameViewer.setContentProvider((IContentProvider)nameCP);
        this.nameViewer.setLabelProvider((IBaseLabelProvider)nameLP);
    }

    protected void createDescriptionControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 20;
        grid.verticalSpacing = 0;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Composite descComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(2, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        descComposite.setLayout((Layout)grid);
        descComposite.setLayoutData((Object)new GridData(768));
        Label descLabel = this.editorToolkit.createBoldLabel(descComposite, Messages.LocalizationPage_DescriptionGroupLabel, 64);
        descLabel.setToolTipText(Messages.LocalizationPage_DescriptionGroupTooltip);
        GridData data = new GridData(1, 1, true, false);
        descLabel.setLayoutData((Object)data);
        Composite tableBtns = this.editorToolkit.createComposite(descComposite);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        this.descriptionAddBtn = this.editorToolkit.createAddButton(tableBtns);
        this.descriptionEditBtn = this.editorToolkit.createEditButton(tableBtns);
        this.descriptionRemoveBtn = this.editorToolkit.createRemoveButton(tableBtns);
        this.descriptionEditBtn.setEnabled(false);
        this.descriptionRemoveBtn.setEnabled(false);
        this.descriptionViewer = new TableViewer(base, 68354);
        Table table = this.descriptionViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(768);
        data.heightHint = 124;
        table.setLayoutData((Object)data);
        TableViewerColumn langColumn = new TableViewerColumn(this.descriptionViewer, 0);
        langColumn.getColumn().setText(Messages.ATTRIBUTE_XML_LANG);
        langColumn.getColumn().setToolTipText(Messages.ATTRIBUTE_XML_LANG_TOOLTIP);
        langColumn.getColumn().pack();
        this.descriptionLangEditingSupport = new DescriptionEditingSupport((ColumnViewer)this.descriptionViewer, 0);
        langColumn.setEditingSupport((EditingSupport)this.descriptionLangEditingSupport);
        TableViewerColumn contentColumn = new TableViewerColumn(this.descriptionViewer, 0);
        contentColumn.getColumn().setText(Messages.LocalizationPage_DescriptionLabel);
        contentColumn.getColumn().setToolTipText(Messages.LocalizationPage_DescrlptionTooltip);
        contentColumn.getColumn().pack();
        this.descriptionContentEditingSupport = new DescriptionEditingSupport((ColumnViewer)this.descriptionViewer, 1);
        contentColumn.setEditingSupport((EditingSupport)this.descriptionContentEditingSupport);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7));
        this.descriptionViewer.getTable().setLayout((Layout)tableLayout);
        DescriptionContentProvider descriptionCP = new DescriptionContentProvider();
        DescriptionLabelProvider descriptionLP = new DescriptionLabelProvider();
        this.descriptionViewer.setContentProvider((IContentProvider)descriptionCP);
        this.descriptionViewer.setLabelProvider((IBaseLabelProvider)descriptionLP);
    }

    protected void createLicenseControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 20;
        grid.verticalSpacing = 0;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Composite licenseComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(2, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        licenseComposite.setLayout((Layout)grid);
        licenseComposite.setLayoutData((Object)new GridData(768));
        Label licenseLabel = this.editorToolkit.createBoldLabel(licenseComposite, Messages.LocalizationPage_LicenseGroupLabel, 64);
        licenseLabel.setToolTipText(Messages.LocalizationPage_LicenseGroupTooltip);
        GridData data = new GridData(1, 1, true, false);
        licenseLabel.setLayoutData((Object)data);
        Composite tableBtns = this.editorToolkit.createComposite(licenseComposite);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        this.licenseAddBtn = this.editorToolkit.createAddButton(tableBtns);
        this.licenseEditBtn = this.editorToolkit.createEditButton(tableBtns);
        this.licenseRemoveBtn = this.editorToolkit.createRemoveButton(tableBtns);
        this.licenseEditBtn.setEnabled(false);
        this.licenseRemoveBtn.setEnabled(false);
        this.licenseViewer = new TableViewer(base, 68354);
        Table table = this.licenseViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(768);
        data.heightHint = 124;
        table.setLayoutData((Object)data);
        TableViewerColumn langColumn = new TableViewerColumn(this.licenseViewer, 0);
        langColumn.getColumn().setText(Messages.ATTRIBUTE_XML_LANG);
        langColumn.getColumn().setToolTipText(Messages.ATTRIBUTE_XML_LANG_TOOLTIP);
        langColumn.getColumn().pack();
        this.licenseLangEditingSupport = new LicenseEditingSupport((ColumnViewer)this.licenseViewer, 0);
        langColumn.setEditingSupport((EditingSupport)this.licenseLangEditingSupport);
        TableViewerColumn contentColumn = new TableViewerColumn(this.licenseViewer, 0);
        contentColumn.getColumn().setText(Messages.LocalizationPage_LicenseLabel);
        contentColumn.getColumn().setToolTipText(Messages.LocalizationPage_LicenseTooltip);
        contentColumn.getColumn().pack();
        this.licenseContentEditingSupport = new LicenseEditingSupport((ColumnViewer)this.licenseViewer, 1);
        contentColumn.setEditingSupport((EditingSupport)this.licenseContentEditingSupport);
        TableViewerColumn hrefColumn = new TableViewerColumn(this.licenseViewer, 0);
        hrefColumn.getColumn().setText(Messages.LocalizationPage_LicenseURLLabel);
        hrefColumn.getColumn().setToolTipText(Messages.LocalizationPage_LicenseURLTooltip);
        hrefColumn.getColumn().pack();
        this.licenseHrefEditingSupport = new LicenseEditingSupport((ColumnViewer)this.licenseViewer, 2);
        hrefColumn.setEditingSupport((EditingSupport)this.licenseHrefEditingSupport);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(4));
        this.licenseViewer.getTable().setLayout((Layout)tableLayout);
        LicenseContentProvider licenseCP = new LicenseContentProvider();
        LicenseLabelProvider licenseLP = new LicenseLabelProvider();
        this.licenseViewer.setContentProvider((IContentProvider)licenseCP);
        this.licenseViewer.setLabelProvider((IBaseLabelProvider)licenseLP);
    }

    @Override
    public void setFocus() {
        super.setFocus();
    }

    @Override
    public void saveStatus(ITizenConfigurator config) {
        config.removeAllNames(true);
        for (Name name : this.internalLocaledNames) {
            config.addElement(name);
        }
        this.nameViewer.refresh();
        config.removeAllDescriptions(true);
        for (Description description : this.internalLocaledDescriptions) {
            config.addElement(description);
        }
        this.descriptionViewer.refresh();
        config.removeAllLicenses(true);
        for (License license : this.internalLocaledLicenses) {
            config.addElement(license);
        }
        this.licenseViewer.refresh();
    }

    @Override
    public void loadStatus(ITizenConfigurator config) {
        this.tizenConfig = config;
        this.removeListener();
        this.internalLocaledNames = config.getNames(true);
        this.nameViewer.setInput((Object)config);
        this.nameViewer.refresh();
        this.nameViewer.getTable().setEnabled(true);
        if (this.internalLocaledNames.size() != LocaleDialog.getDefaultLangLength()) {
            this.nameAddBtn.setEnabled(true);
        } else {
            this.nameAddBtn.setEnabled(false);
        }
        this.internalLocaledDescriptions = config.getDescriptions(true);
        this.descriptionViewer.setInput((Object)config);
        this.descriptionViewer.refresh();
        this.descriptionViewer.getTable().setEnabled(true);
        if (this.internalLocaledDescriptions.size() != LocaleDialog.getDefaultLangLength()) {
            this.descriptionAddBtn.setEnabled(true);
        } else {
            this.descriptionAddBtn.setEnabled(false);
        }
        this.internalLocaledLicenses = config.getLicenses(true);
        this.licenseViewer.setInput((Object)config);
        this.licenseViewer.refresh();
        this.licenseViewer.getTable().setEnabled(true);
        this.addListener();
    }

    @Override
    public void addListener() {
        this.createListener();
        if (this.nameViewerDoubleClickListener != null) {
            this.nameViewer.addDoubleClickListener(this.nameViewerDoubleClickListener);
        }
        if (this.descriptionViewerDoubleClickListener != null) {
            this.descriptionViewer.addDoubleClickListener(this.descriptionViewerDoubleClickListener);
        }
        if (this.licenseViewerDoubleClickListener != null) {
            this.licenseViewer.addDoubleClickListener(this.licenseViewerDoubleClickListener);
        }
        if (this.nameViewerSelectionChangedListener != null) {
            this.nameViewer.addSelectionChangedListener(this.nameViewerSelectionChangedListener);
        }
        if (this.descriptionViewerSelectionChangedListener != null) {
            this.descriptionViewer.addSelectionChangedListener(this.descriptionViewerSelectionChangedListener);
        }
        if (this.licenseViewerSelectionChangedListener != null) {
            this.licenseViewer.addSelectionChangedListener(this.licenseViewerSelectionChangedListener);
        }
    }

    @Override
    public void removeListener() {
    }

    @Override
    public void createListener() {
        if (this.nameAddBtnSelectionListener == null) {
            this.nameAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (Name name : LocalizationPage.this.internalLocaledNames) {
                        locales.put(name.getLang(), (String)name.getContent().get(0));
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), "Name", locales);
                    if (dlg.open() == 0) {
                        Name name = new Name();
                        name.setLang(dlg.getLang());
                        name.getContent().add(dlg.getContent());
                        LocalizationPage.this.nameViewer.add((Object)name);
                        LocalizationPage.this.internalLocaledNames.add(name);
                        LocalizationPage.this.changeListener.notifyChange();
                    }
                    if (LocalizationPage.this.internalLocaledNames.size() == LocaleDialog.getDefaultLangLength()) {
                        LocalizationPage.this.nameAddBtn.setEnabled(false);
                    }
                }
            };
            this.nameAddBtn.addSelectionListener(this.nameAddBtnSelectionListener);
        }
        if (this.nameEditBtnSelectionListener == null) {
            this.nameEditBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalizationPage.this.openNameEditDialog();
                }
            };
            this.nameEditBtn.addSelectionListener(this.nameEditBtnSelectionListener);
        }
        if (this.nameRemoveBtnSelectionListener == null) {
            this.nameRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = LocalizationPage.this.nameViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof Name)) continue;
                            Name name = (Name)object;
                            LocalizationPage.this.nameViewer.remove((Object)name);
                            LocalizationPage.this.internalLocaledNames.remove(name);
                            LocalizationPage.this.tizenConfig.removeAllNames(true);
                            for (Name internalName : LocalizationPage.this.internalLocaledNames) {
                                LocalizationPage.this.tizenConfig.addElement(internalName);
                            }
                            LocalizationPage.this.changeListener.notifyChange();
                            if (LocalizationPage.this.nameAddBtn.isEnabled()) continue;
                            LocalizationPage.this.nameAddBtn.setEnabled(true);
                        }
                    }
                }
            };
            this.nameRemoveBtn.addSelectionListener(this.nameRemoveBtnSelectionListener);
        }
        if (this.nameViewerDoubleClickListener == null) {
            this.nameViewerDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    LocalizationPage.this.openNameEditDialog();
                }
            };
        }
        if (this.nameViewerSelectionChangedListener == null) {
            this.nameViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        LocalizationPage.this.nameEditBtn.setEnabled(true);
                        LocalizationPage.this.nameRemoveBtn.setEnabled(true);
                    } else {
                        LocalizationPage.this.nameEditBtn.setEnabled(false);
                        LocalizationPage.this.nameRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.descriptionAddBtnSelectionListener == null) {
            this.descriptionAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (Description description : LocalizationPage.this.internalLocaledDescriptions) {
                        locales.put(description.getLang(), (String)description.getContent().get(0));
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), "Description", locales);
                    if (dlg.open() == 0) {
                        Description description = new Description();
                        description.setLang(dlg.getLang());
                        description.getContent().add(dlg.getContent());
                        LocalizationPage.this.descriptionViewer.add((Object)description);
                        LocalizationPage.this.internalLocaledDescriptions.add(description);
                        LocalizationPage.this.changeListener.notifyChange();
                    }
                    if (LocalizationPage.this.internalLocaledDescriptions.size() == LocaleDialog.getDefaultLangLength()) {
                        LocalizationPage.this.descriptionAddBtn.setEnabled(false);
                    }
                }
            };
            this.descriptionAddBtn.addSelectionListener(this.descriptionAddBtnSelectionListener);
        }
        if (this.descriptionEditBtnSelectionListener == null) {
            this.descriptionEditBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalizationPage.this.openDescEditDialog();
                }
            };
            this.descriptionEditBtn.addSelectionListener(this.descriptionEditBtnSelectionListener);
        }
        if (this.descriptionRemoveBtnSelectionListener == null) {
            this.descriptionRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = LocalizationPage.this.descriptionViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof Description)) continue;
                            Description description = (Description)object;
                            LocalizationPage.this.descriptionViewer.remove((Object)description);
                            LocalizationPage.this.internalLocaledDescriptions.remove(description);
                            LocalizationPage.this.tizenConfig.removeAllDescriptions(true);
                            for (Description internalDescription : LocalizationPage.this.internalLocaledDescriptions) {
                                LocalizationPage.this.tizenConfig.addElement(internalDescription);
                            }
                            LocalizationPage.this.changeListener.notifyChange();
                            if (LocalizationPage.this.descriptionAddBtn.isEnabled()) continue;
                            LocalizationPage.this.descriptionAddBtn.setEnabled(true);
                        }
                    }
                }
            };
            this.descriptionRemoveBtn.addSelectionListener(this.descriptionRemoveBtnSelectionListener);
        }
        if (this.descriptionViewerDoubleClickListener == null) {
            this.descriptionViewerDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    LocalizationPage.this.openDescEditDialog();
                }
            };
        }
        if (this.descriptionViewerSelectionChangedListener == null) {
            this.descriptionViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        LocalizationPage.this.descriptionEditBtn.setEnabled(true);
                        LocalizationPage.this.descriptionRemoveBtn.setEnabled(true);
                    } else {
                        LocalizationPage.this.descriptionEditBtn.setEnabled(false);
                        LocalizationPage.this.descriptionRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.licenseAddBtnSelectionListener == null) {
            this.licenseAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (License license : LocalizationPage.this.internalLocaledLicenses) {
                        locales.put(license.getLang(), (String)license.getContent().get(0));
                    }
                    LicenseDialog dlg = new LicenseDialog(SWTUtil.getActiveShell(), locales);
                    if (dlg.open() == 0) {
                        License license = new License();
                        license.setLang(dlg.getLang());
                        license.getContent().add(dlg.getContent());
                        if (!StringUtil.isEmpty((CharSequence)dlg.getHref())) {
                            license.setHref(dlg.getHref());
                        }
                        LocalizationPage.this.licenseViewer.add((Object)license);
                        LocalizationPage.this.internalLocaledLicenses.add(license);
                        LocalizationPage.this.changeListener.notifyChange();
                    }
                    if (LocalizationPage.this.internalLocaledLicenses.size() == LicenseDialog.getDefaultLangLength()) {
                        LocalizationPage.this.licenseAddBtn.setEnabled(false);
                    }
                }
            };
            this.licenseAddBtn.addSelectionListener(this.licenseAddBtnSelectionListener);
        }
        if (this.licenseEditBtnSelectionListener == null) {
            this.licenseEditBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalizationPage.this.openLicenseEditDialog();
                }
            };
            this.licenseEditBtn.addSelectionListener(this.licenseEditBtnSelectionListener);
        }
        if (this.licenseRemoveBtnSelectionListener == null) {
            this.licenseRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = LocalizationPage.this.licenseViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof License)) continue;
                            License license = (License)object;
                            LocalizationPage.this.licenseViewer.remove((Object)license);
                            LocalizationPage.this.internalLocaledLicenses.remove(license);
                            LocalizationPage.this.tizenConfig.removeAllLicenses(true);
                            for (License internalLicense : LocalizationPage.this.internalLocaledLicenses) {
                                LocalizationPage.this.tizenConfig.addElement(internalLicense);
                            }
                            LocalizationPage.this.changeListener.notifyChange();
                            if (LocalizationPage.this.licenseAddBtn.isEnabled()) continue;
                            LocalizationPage.this.licenseAddBtn.setEnabled(true);
                        }
                    }
                }
            };
            this.licenseRemoveBtn.addSelectionListener(this.licenseRemoveBtnSelectionListener);
        }
        if (this.licenseViewerDoubleClickListener == null) {
            this.licenseViewerDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    LocalizationPage.this.openLicenseEditDialog();
                }
            };
        }
        if (this.licenseViewerSelectionChangedListener == null) {
            this.licenseViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        LocalizationPage.this.licenseEditBtn.setEnabled(true);
                        LocalizationPage.this.licenseRemoveBtn.setEnabled(true);
                    } else {
                        LocalizationPage.this.licenseEditBtn.setEnabled(false);
                        LocalizationPage.this.licenseRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.changeListener == null) {
            this.changeListener = new AbstractChangeListener(){

                @Override
                public void notifyChange() {
                    LocalizationPage.this.markDirty();
                }
            };
        }
    }

    private void openNameEditDialog() {
        IStructuredSelection selection = (IStructuredSelection)this.nameViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Name selectedName = (Name)selection.getFirstElement();
        HashMap<String, String> locales = new HashMap<String, String>();
        for (Name name : this.internalLocaledNames) {
            locales.put(name.getLang(), (String)name.getContent().get(0));
        }
        LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), "Name", locales);
        dlg.editLang(selectedName.getLang(), (String)selectedName.getContent().get(0));
        if (dlg.open() == 0) {
            selectedName.setLang(dlg.getLang());
            selectedName.getContent().clear();
            selectedName.getContent().add(dlg.getContent());
            this.nameViewer.update((Object)selectedName, null);
            this.changeListener.notifyChange();
        }
    }

    private void openDescEditDialog() {
        IStructuredSelection selection = (IStructuredSelection)this.descriptionViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Description selectedDescription = (Description)selection.getFirstElement();
        HashMap<String, String> locales = new HashMap<String, String>();
        for (Description description : this.internalLocaledDescriptions) {
            locales.put(description.getLang(), (String)description.getContent().get(0));
        }
        LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), "Description", locales);
        dlg.editLang(selectedDescription.getLang(), (String)selectedDescription.getContent().get(0));
        if (dlg.open() == 0) {
            selectedDescription.setLang(dlg.getLang());
            selectedDescription.getContent().clear();
            selectedDescription.getContent().add(dlg.getContent());
            this.descriptionViewer.update((Object)selectedDescription, null);
            this.changeListener.notifyChange();
        }
    }

    private void openLicenseEditDialog() {
        IStructuredSelection selection = (IStructuredSelection)this.licenseViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        License selectedLicense = (License)selection.getFirstElement();
        HashMap<String, String> locales = new HashMap<String, String>();
        for (License license : this.internalLocaledLicenses) {
            locales.put(license.getLang(), (String)license.getContent().get(0));
        }
        LicenseDialog dlg = new LicenseDialog(SWTUtil.getActiveShell(), locales);
        dlg.editLang(selectedLicense.getLang(), (String)selectedLicense.getContent().get(0));
        dlg.setHref(selectedLicense.getHref());
        if (dlg.open() == 0) {
            selectedLicense.setLang(dlg.getLang());
            selectedLicense.getContent().clear();
            selectedLicense.getContent().add(dlg.getContent());
            if (StringUtil.isEmpty((CharSequence)dlg.getHref())) {
                selectedLicense.setHref(null);
            } else {
                selectedLicense.setHref(dlg.getHref());
            }
            this.licenseViewer.update((Object)selectedLicense, null);
            this.changeListener.notifyChange();
        }
    }
}

