/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.page;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.IGroupTableEvent;
import org.tizen.web.editor.configuration.tizen.bgcategory.BgCategoryContentProvider;

public class UiGroupTable
implements SelectionListener,
ISelectionChangedListener {
    private TableViewer fTableViewer;
    private Button fAddBtn;
    private Button fRemoveBtn;
    private IGroupTableEvent fEventHandler;
    private Group tableGroup;

    public UiGroupTable(FormToolkit formtoolkit, Composite parent, String groupTitle, String desc, String[] columnNames, BgCategoryContentProvider contentProvider, ITableLabelProvider labelProvider) {
        this.createGroup(formtoolkit, parent, groupTitle, desc, columnNames, (IContentProvider)contentProvider, labelProvider);
    }

    public void setEventHandler(IGroupTableEvent eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected void createGroup(FormToolkit formtoolkit, Composite parent, String groupTitle, String desc, String[] columnNames, IContentProvider contentProvider, ITableLabelProvider labelProvider) {
        GridData tableViewGroupGridData = new GridData(1808);
        tableViewGroupGridData.heightHint = 120;
        this.tableGroup = new Group(parent, 0);
        this.tableGroup.setText(groupTitle);
        this.tableGroup.setToolTipText(desc);
        this.tableGroup.setLayout((Layout)new GridLayout(2, false));
        this.tableGroup.setLayoutData((Object)tableViewGroupGridData);
        this.tableGroup.setEnabled(true);
        Composite tableComposite = formtoolkit.createComposite((Composite)this.tableGroup);
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        tableComposite.setLayoutData((Object)new GridData(1808));
        Table tableWidget = formtoolkit.createTable(tableComposite, 68352);
        tableWidget.setHeaderVisible(true);
        tableWidget.setLinesVisible(true);
        tableWidget.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(tableWidget, 0);
            column.setText(columnNames[i]);
            ++i;
        }
        TableLayout tl = new TableLayout();
        int width = 100 / columnNames.length;
        int i2 = 0;
        while (i2 < columnNames.length) {
            tl.addColumnData((ColumnLayoutData)new ColumnWeightData(width, 50, true));
            ++i2;
        }
        tableWidget.setLayout((Layout)tl);
        this.fTableViewer = new TableViewer(tableWidget);
        if (contentProvider != null) {
            this.fTableViewer.setContentProvider(contentProvider);
        }
        if (labelProvider != null) {
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
        this.fTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite buttonComposite = formtoolkit.createComposite((Composite)this.tableGroup);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(2));
        this.fAddBtn = formtoolkit.createButton(buttonComposite, Messages.AddButtonLabel, 8);
        this.fAddBtn.setLayoutData((Object)new GridData(768));
        this.fAddBtn.addSelectionListener((SelectionListener)this);
        this.fRemoveBtn = formtoolkit.createButton(buttonComposite, Messages.RemoveButtonLabel, 8);
        this.fRemoveBtn.setLayoutData((Object)new GridData(768));
        this.fRemoveBtn.addSelectionListener((SelectionListener)this);
        this.fRemoveBtn.setEnabled(false);
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public void setEnabled(boolean enable) {
        this.tableGroup.setEnabled(enable);
        this.fTableViewer.getTable().setEnabled(enable);
        this.fAddBtn.setEnabled(enable);
        if (enable) {
            if (this.fTableViewer.getSelection().isEmpty()) {
                this.fRemoveBtn.setEnabled(false);
            } else {
                this.fRemoveBtn.setEnabled(true);
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.fEventHandler == null) {
            return;
        }
        if (e.widget == this.fAddBtn) {
            this.fEventHandler.onAdd();
        }
        if (e.widget == this.fRemoveBtn) {
            this.fEventHandler.onRemove();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            this.fRemoveBtn.setEnabled(false);
        } else {
            this.fRemoveBtn.setEnabled(true);
        }
    }
}

