/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.privilege;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;

public class PrivilegeEditingSupport
extends EditingSupport {
    private int column;
    private boolean editable;
    private CellEditor editor;
    private AbstractChangeListener listener;

    public PrivilegeEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.column = column;
        this.editable = false;
        switch (column) {
            case 0: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return this.editable;
            }
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof PrivilegeWrapper)) {
            return null;
        }
        PrivilegeWrapper privilege = (PrivilegeWrapper)element;
        switch (this.column) {
            case 0: {
                String name = privilege.getName();
                if (name != null) {
                    return name;
                }
                return "";
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof PrivilegeWrapper)) {
            return;
        }
        PrivilegeWrapper privilege = (PrivilegeWrapper)element;
        switch (this.column) {
            case 0: {
                privilege.setName((String)value);
                break;
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public void unsetListener() {
        this.listener = null;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

