/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.webwidget.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.error.BuildErrorInfo;
import org.tizen.common.builder.error.Location;
import org.tizen.common.file.IResource;
import org.tizen.web.webwidget.validator.core.ValidatedIssue;
import org.tizen.web.webwidget.validator.util.ValidatorUtil;

public class HtmlCssValidatorChecker {
    protected final Logger logger = LoggerFactory.getLogger(HtmlCssValidatorChecker.class);
    protected int severity = 2;
    private static HtmlCssValidatorChecker instance;

    public static HtmlCssValidatorChecker getInstance() {
        if (instance == null) {
            instance = new HtmlCssValidatorChecker();
        }
        return instance;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Collection<BuildErrorInfo> validate(IProject project, IResource res, IProgressMonitor monitor) {
        Collection<ValidatedIssue> issues = this.runValidator(project, res, monitor);
        if (issues == null) {
            return null;
        }
        HashSet<BuildErrorInfo> buildErrInfos = new HashSet<BuildErrorInfo>();
        for (ValidatedIssue issue : issues) {
            Location location = new Location(issue.getResource(project.getLocation().toString()), issue.getLine(), -1);
            BuildErrorInfo info = new BuildErrorInfo(location, issue.getBuildInfoSeverity(), issue.getMessage());
            buildErrInfos.add(info);
        }
        return buildErrInfos;
    }

    private Collection<ValidatedIssue> runValidator(IProject project, IResource res, IProgressMonitor monitor) {
        if (project == null || res == null) {
            return null;
        }
        IFile validateFile = project.getFile(res.getPath());
        if (validateFile == null || !validateFile.exists()) {
            return null;
        }
        if (!validateFile.getLocation().toOSString().contains("widget" + File.separator + project.getName())) {
            return null;
        }
        return this.runHtmlCssValidator(project, validateFile, false, monitor);
    }

    private Collection<ValidatedIssue> runHtmlCssValidator(IProject project, IFile validateFile, boolean isBuildErrorInfo, IProgressMonitor monitor) {
        IPath projectPath = project.getLocation();
        HashMap<String, ArrayList<ValidatedIssue>> vIssueMap = ValidatorUtil.executeWithFile(validateFile, monitor);
        if (vIssueMap == null) {
            return null;
        }
        ArrayList<ValidatedIssue> vIssueResults = null;
        Set<String> keys = vIssueMap.keySet();
        if (isBuildErrorInfo) {
            for (String key : keys) {
                ArrayList<ValidatedIssue> item = vIssueMap.get(key);
                if (vIssueResults == null) {
                    vIssueResults = vIssueMap.get(key);
                    continue;
                }
                vIssueResults.addAll(item);
            }
        } else {
            try {
                for (String key : keys) {
                    vIssueResults = vIssueMap.get(key);
                    String projectLocation = projectPath.toString();
                    if (projectLocation != null) {
                        File file = new File(String.valueOf(projectLocation) + File.separator + "widget" + File.separator + project.getName() + File.separator + key);
                        IFile markingFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
                        markingFile.deleteMarkers("org.tizen.webwidget.builder.marker.validator", true, 0);
                        for (ValidatedIssue r : vIssueResults) {
                            IMarker marker = markingFile.createMarker("org.tizen.webwidget.builder.marker.validator");
                            marker.setAttribute("message", (Object)r.getMessage());
                            marker.setAttribute("lineNumber", r.getLine());
                            marker.setAttribute("severity", r.getSeverity() == 'E' ? 2 : 1);
                        }
                    }
                    vIssueResults = null;
                }
            }
            catch (CoreException ce) {
                this.logger.error(ce.getMessage(), (Throwable)ce);
            }
        }
        return vIssueResults;
    }
}

