/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.webwidget.validator.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.Executor;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.webwidget.validator.core.HtmlCssValidatorCheckHelper;
import org.tizen.web.webwidget.validator.core.ValidatedIssue;
import org.tizen.web.webwidget.validator.util.Messages;

public class ValidatorUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ValidatorUtil.class);
    static final String WEBWIDGET_VALIDATOR_PATH = String.valueOf(InstallPathConfig.getToolsPath()) + File.separator + "web-widget-validator";
    static final String VALIDATOR_JS_PATH = String.valueOf(WEBWIDGET_VALIDATOR_PATH) + File.separator + "validator.js" + " ";
    static final String VALIDATOR_NODE_COMMAND;
    static final String VALIDATOR_JS_COMMAND;
    static final OStype type;

    static {
        String VALIDATOR_NODE_PATH = String.valueOf(WEBWIDGET_VALIDATOR_PATH) + File.separator + "node";
        if (OSChecker.isWindows()) {
            type = OStype.WIN;
            VALIDATOR_NODE_COMMAND = String.valueOf(VALIDATOR_NODE_PATH) + File.separator + "bin" + File.separator + "node.exe" + " ";
            VALIDATOR_JS_COMMAND = String.valueOf(WEBWIDGET_VALIDATOR_PATH) + File.separator + "run-js-rule-checker.bat" + " ";
        } else if (OSChecker.isLinux() || OSChecker.isMAC()) {
            type = OStype.OTHERS;
            VALIDATOR_NODE_COMMAND = String.valueOf(VALIDATOR_NODE_PATH) + File.separator + "bin" + File.separator + "node" + " ";
            VALIDATOR_JS_COMMAND = String.valueOf(WEBWIDGET_VALIDATOR_PATH) + File.separator + "run-js-rule-checker.sh" + " ";
        } else {
            type = OStype.UNKNOWN;
            VALIDATOR_NODE_COMMAND = "";
            VALIDATOR_JS_COMMAND = "";
        }
    }

    public static String[] getExcludes() throws CoreException {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(Arrays.asList(WebConstant.DEFAULT_EXCLUDING_RESOURCES));
        excludes.addAll(Arrays.asList(HtmlCssValidatorCheckHelper.getExcludeFolders()));
        return excludes.toArray(new String[0]);
    }

    public static ValidatedIssue parsingResultMessage(String resultMessage) throws CoreException {
        if (resultMessage.contains(":")) {
            String[] fileNameWithLine = resultMessage.split(":");
            String fileName = fileNameWithLine[0];
            int line = Integer.parseInt(fileNameWithLine[1]);
            String[] columns = fileNameWithLine[2].split(" ");
            int postion = Integer.parseInt(columns[0]);
            char sevirity = columns[1].charAt(0);
            String message = fileNameWithLine[2].substring(fileNameWithLine[2].indexOf(sevirity) + 2, fileNameWithLine[2].length());
            ValidatedIssue vIssue = new ValidatedIssue(fileName, line, postion, sevirity, message);
            return vIssue;
        }
        DialogUtil.openErrorDialog((String)Messages.Validator_js_wrong_result_error);
        throw new CoreException((IStatus)new Status(4, "org.tizen.web.webwidget.validator", Messages.Validator_js_wrong_result_error, (Throwable)new Exception()));
    }

    public static ArrayList<ValidatedIssue> parsingResultMessage(ArrayList<String> ResultMessages) throws CoreException {
        ArrayList<ValidatedIssue> Results = new ArrayList<ValidatedIssue>();
        for (String item : ResultMessages) {
            if (StringUtil.isEmpty((CharSequence)item)) continue;
            Results.add(ValidatorUtil.parsingResultMessage(item));
        }
        return Results;
    }

    public static HashMap<String, ArrayList<ValidatedIssue>> refineResult2Map(ArrayList<ValidatedIssue> parsingResults) {
        HashMap<String, ArrayList<ValidatedIssue>> itemMap = new HashMap<String, ArrayList<ValidatedIssue>>();
        for (ValidatedIssue vIssue : parsingResults) {
            ArrayList<Object> ResultItems;
            String name = vIssue.getFileName();
            if (itemMap.get(name) == null) {
                ResultItems = new ArrayList<ValidatedIssue>();
                ResultItems.add(vIssue);
                itemMap.put(name, ResultItems);
                continue;
            }
            ResultItems = itemMap.get(name);
            ResultItems.add(vIssue);
        }
        return itemMap;
    }

    /*
     * Exception decompiling
     */
    public static HashMap<String, ArrayList<ValidatedIssue>> executeWithFile(IFile validateFile, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isExist(String command) {
        if (FileUtil.isExist((String)command.trim())) {
            return true;
        }
        Executor executor = CommonPlugin.getDefault().getExecutor();
        executor.getContext().getPrompter().notify("Please check install version, Can not find: " + command);
        return false;
    }

    /*
     * Exception decompiling
     */
    public static HashMap<String, ArrayList<ValidatedIssue>> executeWithFolder(String projectPath, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    private static ArrayList<String> changeMassagefromProjectName(ArrayList<String> resultList, String projectName) {
        ArrayList<String> removedSeparatorList = new ArrayList<String>();
        for (String s : resultList) {
            if (StringUtil.isEmpty((CharSequence)s)) continue;
            if (s.toLowerCase().contains(projectName.toLowerCase())) {
                removedSeparatorList.add(s.substring(projectName.length(), s.length()));
                continue;
            }
            removedSeparatorList.add(s);
        }
        return removedSeparatorList;
    }

    public static enum OStype {
        WIN("win"),
        OTHERS("others"),
        UNKNOWN("unknown");

        private String type;

        private OStype(String type) {
            this.type = type;
        }
    }
}

