/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.livereload.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.web.livereload.ILiveReloadListener;
import org.tizen.web.livereload.LiveReloadEvent;
import org.tizen.web.livereload.servlet.LiveReloadSocketManager;
import org.tizen.web.livereload.servlet.WebSocketMessage;

public class LiveReloadSocket
implements WebSocket.OnTextMessage,
Closeable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final LiveReloadSocketManager manager;
    protected WebSocket.Connection con;
    protected ObjectMapper mapper = new ObjectMapper();
    protected String magic;

    public LiveReloadSocket(LiveReloadSocketManager manager) {
        Assert.notNull((Object)manager);
        this.manager = manager;
    }

    public void onOpen(WebSocket.Connection con) {
        this.logger.info("Connected :{}", (Object)con);
        this.manager.add(this);
        this.con = con;
    }

    public void onClose(int code, String message) {
        this.logger.info("Closed :{} - {}", (Object)code, (Object)message);
        this.manager.remove(this, this.magic);
    }

    public void onMessage(String message) {
        try {
            this.logger.debug("Message :{}", (Object)message);
            JsonNode req = this.mapper.readTree(message);
            JsonNode commandNode = req.path("command");
            if (commandNode == null) {
                return;
            }
            if ("hello".equals(commandNode.getTextValue())) {
                JsonNode magicNode = req.path("magic");
                this.magic = magicNode.getTextValue();
                this.logger.debug("Magic: {}", (Object)this.magic);
                WebSocketMessage res = new WebSocketMessage();
                res.setCommand("hello");
                res.setProtocols(Arrays.asList("http://livereload.com/protocols/official-7"));
                res.setServerName("tizen-pic");
                this.send(res);
                this.manager.initialize(this);
                LiveReloadEvent event = new LiveReloadEvent(this.magic, this, null);
                this.logger.debug("Event: {}, Manager: {}, Listeners: {}", new Object[]{event, this.manager, this.manager.listeners});
                for (ILiveReloadListener listener : this.manager.listeners) {
                    listener.onConnected(event);
                }
            } else {
                LiveReloadEvent event = new LiveReloadEvent(this.magic, this, message);
                for (ILiveReloadListener listener : this.manager.listeners) {
                    listener.onMessage(event);
                }
            }
        }
        catch (JsonParseException e) {
            this.logger.error("Exception occured:", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error("Exception occured:", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Exception occured:", (Throwable)e);
        }
    }

    public void send(WebSocketMessage message) throws IOException {
        this.send(this.mapper.writeValueAsString((Object)message));
    }

    public void send(String message) throws IOException {
        this.logger.info("Send message :{}", (Object)message);
        this.con.sendMessage(message);
    }

    @Override
    public void close() throws IOException {
        if (this.con != null) {
            this.con.close();
        }
    }
}

