/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.tizen.web.common.WebCommonActivator;
import org.tizen.web.preferences.Messages;

public class WebPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text text;

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 16384);
        label.setText(Messages.WebPreferencePage_0);
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        this.text = new Text(result, 2048);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        IPreferenceStore prefs = this.getPreferenceStore();
        if (prefs != null) {
            String defaultURI = prefs.getString("org.tizen.web.common.widget.uri");
            if (defaultURI.isEmpty()) {
                prefs.setValue("org.tizen.web.common.widget.uri", "http://yourdomain/");
            }
            this.text.setText(prefs.getString("org.tizen.web.common.widget.uri"));
        }
        return result;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(WebCommonActivator.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.tizen.ide.web.preferences_context");
    }

    public boolean performOk() {
        IPreferenceStore prefs = this.getPreferenceStore();
        if (prefs != null) {
            prefs.setValue("org.tizen.web.common.widget.uri", this.text.getText());
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.text.setText("http://yourdomain/");
        super.performDefaults();
    }
}

