/*
 * Decompiled with CFR 0.152.
 */
package io.emmet;

import io.emmet.Emmet;
import io.emmet.TabStop;
import io.emmet.TabStopGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class TabStopStructure {
    private String text = "";
    private HashMap<String, TabStopGroup> groups;

    public TabStopStructure(String text) {
        this.createGroups();
        Emmet jse = Emmet.getSingleton();
        Scriptable tabstopData = (Scriptable)jse.execJSFunction("javaExtractTabstops", text);
        if (tabstopData != null) {
            text = Context.toString((Object)ScriptableObject.getProperty((Scriptable)tabstopData, (String)"text"));
            NativeArray tabstops = (NativeArray)ScriptableObject.getProperty((Scriptable)tabstopData, (String)"tabstops");
            int i = 0;
            while ((long)i < tabstops.getLength()) {
                NativeObject tabstopItem = (NativeObject)ScriptableObject.getProperty((Scriptable)tabstops, (int)i);
                this.addTabStopToGroup(Context.toString((Object)ScriptableObject.getProperty((Scriptable)tabstopItem, (String)"group")), (int)Context.toNumber((Object)ScriptableObject.getProperty((Scriptable)tabstopItem, (String)"start")), (int)Context.toNumber((Object)ScriptableObject.getProperty((Scriptable)tabstopItem, (String)"end")));
                ++i;
            }
        }
        this.setText(text);
    }

    private void createGroups() {
        this.groups = new HashMap();
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void addTabStopToGroup(String groupName, int start, int end) {
        if (!this.groups.containsKey(groupName)) {
            this.groups.put(groupName, new TabStopGroup());
        }
        this.getTabStopGroup(groupName).addTabStop(start, end);
    }

    public HashMap<String, TabStopGroup> getGroups() {
        return this.groups;
    }

    public int getTabStopsCount() {
        int result = 0;
        for (TabStopGroup item : this.groups.values()) {
            result += item.getLength();
        }
        return result;
    }

    public String[] getSortedGroupKeys() {
        Set<String> keySet = this.groups.keySet();
        Object[] keys = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keys);
        return keys;
    }

    public TabStop getFirstTabStop() {
        String[] names = this.getSortedGroupKeys();
        return names.length > 0 ? this.getTabStop(names[0], 0) : null;
    }

    public TabStopGroup getTabStopGroup(String groupName) {
        return this.groups.get(groupName);
    }

    public TabStop getTabStop(String groupName, int index) {
        ArrayList<TabStop> tabStops = this.getTabStopGroup(groupName).getTabStopList();
        return index < tabStops.size() ? tabStops.get(index) : null;
    }
}

