/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.navigation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.tizen.web.editor.javascript.navigation.SymbolInformation;

public class SymbolNavigatorVisitor
extends ASTVisitor
implements JavaScriptEditorConstants {
    private List<SymbolInformation> symbolList = new ArrayList<SymbolInformation>();
    private IFile file = null;
    private JavaScriptUnit javaScriptUnitAST = null;
    private boolean isEditable = false;
    private IJavaScriptElement javaScriptElement = null;

    public SymbolNavigatorVisitor(IFile file, JavaScriptUnit javaScriptUnitAST, boolean isEditable, IJavaScriptElement javaScriptElement) {
        this.file = file;
        this.javaScriptUnitAST = javaScriptUnitAST;
        this.isEditable = isEditable;
        this.javaScriptElement = javaScriptElement;
    }

    public void preVisit(ASTNode node) {
        SymbolInformation makeSymbolInformation = this.makeSymbolInformation(node);
        if (makeSymbolInformation != null) {
            this.symbolList.add(makeSymbolInformation);
        }
    }

    private int getNextLineStartOffset(JavaScriptUnit jsUnit, int prevNodeLastOffset) {
        int nextOffsetLineNumber;
        int nextLineStartOffset = 0;
        int currentNodeLineNumber = jsUnit.getLineNumber(prevNodeLastOffset);
        while ((nextOffsetLineNumber = jsUnit.getLineNumber(++prevNodeLastOffset)) != currentNodeLineNumber + 1) {
        }
        nextLineStartOffset = prevNodeLastOffset;
        return nextLineStartOffset;
    }

    private SymbolInformation makeSymbolInformation(ASTNode node) {
        SymbolInformation symbolInformation = null;
        int startPosition = node.getStartPosition();
        int length = node.getLength();
        int lineNumber = this.javaScriptUnitAST.getLineNumber(startPosition);
        switch (node.getNodeType()) {
            case 31: {
                SimpleName functionSimpleName = ((FunctionDeclaration)node).getName();
                if (functionSimpleName == null) break;
                JSdoc javaDoc = ((FunctionDeclaration)node).getJavadoc();
                if (javaDoc != null) {
                    int javaDocLength = javaDoc.getLength();
                    startPosition = this.getNextLineStartOffset(this.javaScriptUnitAST, startPosition + javaDocLength);
                    lineNumber = this.javaScriptUnitAST.getLineNumber(startPosition);
                }
                String functionIdentifier = functionSimpleName.getIdentifier();
                symbolInformation = new SymbolInformation(node, functionIdentifier, startPosition, length, lineNumber, this.file, this.isEditable, this.javaScriptElement);
                break;
            }
            case 60: {
                List fragments;
                ASTNode parent = ((VariableDeclarationStatement)node).getParent();
                if (!(parent instanceof JavaScriptUnit) || (fragments = ((VariableDeclarationStatement)node).fragments()).size() <= 0) break;
                int i = 0;
                while (i < fragments.size()) {
                    IVariableBinding resolveBinding;
                    Object object = fragments.get(i);
                    if (object instanceof VariableDeclarationFragment && (resolveBinding = ((VariableDeclarationFragment)object).resolveBinding()) != null && resolveBinding.isGlobal()) {
                        SimpleName variableSimpleName = ((VariableDeclarationFragment)object).getName();
                        String variableIdentifier = variableSimpleName.getIdentifier();
                        JSdoc javaDoc = ((VariableDeclarationStatement)node).getJavadoc();
                        if (javaDoc != null) {
                            int javaDocLength = javaDoc.getLength();
                            startPosition = this.getNextLineStartOffset(this.javaScriptUnitAST, startPosition + javaDocLength);
                            lineNumber = this.javaScriptUnitAST.getLineNumber(startPosition);
                        }
                        symbolInformation = new SymbolInformation(node, variableIdentifier, startPosition, length, lineNumber, this.file, this.isEditable, this.javaScriptElement);
                    }
                    ++i;
                }
                break;
            }
            case 22: {
                String binaryName;
                SimpleName simpleName;
                String fieldAccessExpression = ((FieldAccess)node).getExpression().toString();
                if (fieldAccessExpression != null && fieldAccessExpression.contains(".prototype")) {
                    int indexOf;
                    SimpleName simpleName2 = ((FieldAccess)node).getName();
                    if (simpleName2 == null || simpleName2.getIdentifier() == null || simpleName2.getIdentifier().trim().equals("") || (indexOf = fieldAccessExpression.indexOf(".")) == -1) break;
                    String className = fieldAccessExpression.substring(0, indexOf);
                    String displayName = simpleName2.getIdentifier();
                    symbolInformation = new SymbolInformation((ASTNode)simpleName2, displayName, simpleName2.getStartPosition(), simpleName2.getLength(), lineNumber, this.file, this.isEditable, this.javaScriptElement, className);
                    break;
                }
                if (fieldAccessExpression == null || !fieldAccessExpression.contains("this") || node.getParent() == null || !(node.getParent() instanceof Assignment) || (simpleName = ((FieldAccess)node).getName()) == null || simpleName.getIdentifier() == null || simpleName.getIdentifier().trim().equals("")) break;
                Expression expression = ((FieldAccess)node).getExpression();
                ITypeBinding resolveTypeBinding = expression.resolveTypeBinding();
                String className = null;
                if (resolveTypeBinding != null && (binaryName = resolveTypeBinding.getBinaryName()) != null) {
                    className = binaryName;
                }
                String displayName = simpleName.getIdentifier();
                symbolInformation = new SymbolInformation((ASTNode)simpleName, displayName, simpleName.getStartPosition(), simpleName.getLength(), lineNumber, this.file, this.isEditable, this.javaScriptElement, className);
                break;
            }
            case 7: {
                Expression index;
                ITypeBinding type;
                IBinding resolveBinding;
                Expression array;
                Expression leftHandSide = ((Assignment)node).getLeftHandSide();
                if (leftHandSide instanceof SimpleName) {
                    boolean global;
                    IBinding resolvedBinding = ((SimpleName)leftHandSide).resolveBinding();
                    if (!(resolvedBinding instanceof IVariableBinding) || !(global = ((IVariableBinding)resolvedBinding).isGlobal())) break;
                    String displayName = ((SimpleName)leftHandSide).getIdentifier();
                    symbolInformation = new SymbolInformation((ASTNode)leftHandSide, displayName, leftHandSide.getStartPosition(), leftHandSide.getLength(), lineNumber, this.file, this.isEditable, this.javaScriptElement);
                    break;
                }
                if (!(leftHandSide instanceof ArrayAccess) || !((array = ((ArrayAccess)leftHandSide).getArray()) instanceof SimpleName) || !((resolveBinding = ((SimpleName)array).resolveBinding()) instanceof IVariableBinding) || (type = ((IVariableBinding)resolveBinding).getType()) == null || node.getParent() == null || node.getParent().getParent() == null || !(node.getParent().getParent() instanceof JavaScriptUnit) || !((index = ((ArrayAccess)leftHandSide).getIndex()) instanceof StringLiteral)) break;
                String displayName = ((StringLiteral)index).getLiteralValue();
                if (displayName != null && (displayName.startsWith("'") || displayName.startsWith("\""))) {
                    displayName = displayName.substring(1, displayName.length() - 1);
                }
                symbolInformation = new SymbolInformation((ASTNode)array, displayName, array.getStartPosition(), array.getLength(), lineNumber, this.file, this.isEditable, this.javaScriptElement, ((SimpleName)array).getIdentifier());
                break;
            }
            case 86: {
                IVariableBinding resolveBinding;
                ASTNode objectLiteralParent;
                Expression fieldName = ((ObjectLiteralField)node).getFieldName();
                if (!(fieldName instanceof SimpleName) || node.getParent() == null || !((objectLiteralParent = node.getParent().getParent()) instanceof VariableDeclarationFragment) || (resolveBinding = ((VariableDeclarationFragment)objectLiteralParent).resolveBinding()) == null || !resolveBinding.isGlobal()) break;
                SimpleName simpleName = ((VariableDeclarationFragment)objectLiteralParent).getName();
                String displayName = ((SimpleName)fieldName).getIdentifier();
                symbolInformation = new SymbolInformation((ASTNode)fieldName, displayName, fieldName.getStartPosition(), fieldName.getLength(), lineNumber, this.file, this.isEditable, this.javaScriptElement, simpleName.getIdentifier());
                break;
            }
        }
        return symbolInformation;
    }

    public List<SymbolInformation> getSymbolList() {
        return this.symbolList;
    }

    public void setSymbolList(List<SymbolInformation> symbolList) {
        this.symbolList = symbolList;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public JavaScriptUnit getJavaScriptUnitAST() {
        return this.javaScriptUnitAST;
    }

    public void setJavaScriptUnitAST(JavaScriptUnit javaScriptUnitAST) {
        this.javaScriptUnitAST = javaScriptUnitAST;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public IJavaScriptElement getJavaScriptElement() {
        return this.javaScriptElement;
    }

    public void setJavaScriptElement(IJavaScriptElement javaScriptElement) {
        this.javaScriptElement = javaScriptElement;
    }
}

