/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.lv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.lv.ITizenLocalizer;
import org.tizen.common.lv.ITizenLocalizerAdapter;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.model.LVStringVO;
import org.tizen.common.lv.ui.helper.RefreshProjectExplorerJob;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.lv.LVWebConstants;
import org.tizen.web.lv.LVWebProjectExplorer;

public class LVWebLocalizer
implements ITizenLocalizerAdapter,
ITizenLocalizer {
    protected static final Logger logger = LoggerFactory.getLogger(LVWebLocalizer.class);

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean canHandle(IProject project) {
        return ProjectUtil.isTizenWebProject((IProject)project);
    }

    public ITizenLocalizer getTizenLocalizer() {
        return this;
    }

    public void readLocalizedContent(IProject project) {
        IFile stringFileForDefaultLocale = this.getStringFileForDefaultLocale(project);
        if (stringFileForDefaultLocale.exists()) {
            LVWebProjectExplorer.getStringsFromFile(project, stringFileForDefaultLocale, LVManager.getDefaultLocale());
            IFolder containerForLocalizedContent = LVWebProjectExplorer.getContainerForLocalizedContent(project, false);
            if (containerForLocalizedContent != null) {
                try {
                    IResource[] members = containerForLocalizedContent.members();
                    Map supportLocalesMap = LVManager.getManager((IProject)project).getSupportLocaleMap();
                    IFile stringFileForLocale = null;
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (resource.getType() == 2 && supportLocalesMap.containsKey(resource.getName())) {
                            LVLocaleVO locale = (LVLocaleVO)supportLocalesMap.get(resource.getName());
                            IFolder localeFolder = (IFolder)resource;
                            if (localeFolder != null) {
                                LVManager.getManager((IProject)project).addTargetLocales(new LVLocaleVO[]{locale}, false);
                                stringFileForLocale = LVWebProjectExplorer.getFileForLocalizedContent(localeFolder, false);
                                LVWebProjectExplorer.getStringsFromFile(project, stringFileForLocale, locale);
                            }
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    logger.error("Fail to get strings from file", (Throwable)e);
                }
            }
        }
    }

    private IFile getStringFileForDefaultLocale(IProject project) {
        return project.getFile("language.js");
    }

    public String[][] getSupportLocales() {
        return LVWebConstants.WRT_LANGTAGS;
    }

    public void createLocaleFolder(IProject project, LVLocaleVO[] newLocales) {
        IFolder containerForLocalizedContent = LVWebProjectExplorer.getContainerForLocalizedContent(project);
        if (containerForLocalizedContent != null) {
            LVWebProjectExplorer.createLocaleFolders(project, containerForLocalizedContent, newLocales);
        }
    }

    public void deleteLocaleFolder(IProject project, LVLocaleVO[] oldLocales) {
        IFolder containerForLocalizedContent = LVWebProjectExplorer.getContainerForLocalizedContent(project);
        if (containerForLocalizedContent != null) {
            LVWebProjectExplorer.deleteLocaleFolders(project, containerForLocalizedContent, oldLocales);
        }
    }

    public void updateStrings(IProject project) {
        List targetLocaleList = LVManager.getManager((IProject)project).getTargetLocaleList();
        IFolder containerForLocalizedContent = LVWebProjectExplorer.getContainerForLocalizedContent(project);
        if (containerForLocalizedContent != null) {
            for (LVLocaleVO locale : targetLocaleList) {
                LVWebProjectExplorer.updateStringContents(project, containerForLocalizedContent, locale);
            }
            new RefreshProjectExplorerJob().schedule();
        }
    }

    public void removeStringsByLocale(IProject project, LVLocaleVO locale) {
        IFolder containerForLocalizedContent = LVWebProjectExplorer.getContainerForLocalizedContent(project);
        if (containerForLocalizedContent != null) {
            LVWebProjectExplorer.updateStringContents(project, containerForLocalizedContent, locale);
            new RefreshProjectExplorerJob().schedule();
        }
    }

    public void removeStringsById(IProject project, String id) {
        List targetLocaleList = LVManager.getManager((IProject)project).getTargetLocaleList();
        IFolder containerForLocalizedContent = LVWebProjectExplorer.getContainerForLocalizedContent(project);
        if (containerForLocalizedContent != null) {
            for (LVLocaleVO locale : targetLocaleList) {
                LVWebProjectExplorer.updateStringContents(project, containerForLocalizedContent, locale);
            }
            new RefreshProjectExplorerJob().schedule();
        }
    }

    public void updateString(IProject project, LVStringVO svo) {
        IFolder containerForLocalizedContent = LVWebProjectExplorer.getContainerForLocalizedContent(project);
        LVLocaleVO locale = svo.getLocale();
        if (containerForLocalizedContent != null) {
            LVWebProjectExplorer.updateStringContents(project, containerForLocalizedContent, locale);
            new RefreshProjectExplorerJob().schedule();
        }
    }

    public boolean isValidKey(String key) {
        Matcher matcher = LVWebConstants.keyPattern.matcher(key);
        return matcher.matches();
    }

    public void ImportLocalizedString(IProject project, File file) {
        block8: {
            boolean hasHeader = false;
            if (file != null && file.exists()) {
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new FileReader(file));
                        String line = br.readLine();
                        hasHeader = this.readHeader(project, line);
                        line = br.readLine();
                        while (line != null && line.length() > 0) {
                            this.readLocalizedString(project, line);
                            line = br.readLine();
                        }
                        if (hasHeader) {
                            this.updateStrings(project);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Fail to read string contents", (Throwable)e);
                        IOUtil.tryClose((Object[])new Object[]{br});
                        new RefreshProjectExplorerJob().schedule();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{br});
                    new RefreshProjectExplorerJob().schedule();
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{br});
                new RefreshProjectExplorerJob().schedule();
            }
        }
    }

    private boolean readHeader(IProject project, String line) {
        String[] split;
        boolean result = false;
        if (line != null && line.length() > 0 && "Key".equals((split = line.split(","))[0])) {
            LVManager manager = LVManager.getManager((IProject)project);
            Map supportLocaleMap = manager.getSupportLocaleMap();
            List oldTargetLocaleList = manager.getTargetLocaleList();
            manager.removeTargetLocale(oldTargetLocaleList.toArray(new LVLocaleVO[0]));
            ArrayList<LVLocaleVO> localeList = new ArrayList<LVLocaleVO>();
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String languageTag = stringArray[n2];
                if (!"Key".equals(languageTag)) {
                    if (LVManager.getDefaultLocale().getLanguageTag().equals(languageTag)) {
                        localeList.add(LVManager.getDefaultLocale());
                    } else {
                        localeList.add((LVLocaleVO)supportLocaleMap.get(languageTag));
                    }
                }
                ++n2;
            }
            manager.addTargetLocales(localeList.toArray(new LVLocaleVO[localeList.size()]));
            result = true;
        }
        return result;
    }

    private void readLocalizedString(IProject project, String line) {
        LVManager manager;
        String[] split = line.split(",");
        if (split.length == (manager = LVManager.getManager((IProject)project)).getTargetLocaleList().size() + 1) {
            String key = split[0];
            List targetLocaleList = manager.getTargetLocaleList();
            ArrayList<LVStringVO> svoList = new ArrayList<LVStringVO>();
            int i = 0;
            while (i < targetLocaleList.size()) {
                LVLocaleVO locale = (LVLocaleVO)targetLocaleList.get(i);
                svoList.add(new LVStringVO(locale, key, split[i + 1]));
                ++i;
            }
            manager.addStrings(svoList, false);
        }
    }

    public void exportLocalizedString(IProject project, File file) {
        block9: {
            StringBuilder sb = new StringBuilder();
            StringBuilder sbContents = new StringBuilder();
            FileWriter fWriter = null;
            LVManager manager = LVManager.getManager((IProject)project);
            List targetLocaleList = manager.getTargetLocaleList();
            List keyList = manager.getStringList(LVManager.getDefaultLocale());
            sbContents.append("Key");
            for (LVLocaleVO locale : targetLocaleList) {
                sbContents.append(",");
                sbContents.append(locale.getLanguageTag());
            }
            sbContents.append("\n");
            sb.append(sbContents.toString());
            for (LVStringVO keySVO : keyList) {
                sbContents = new StringBuilder();
                sbContents.append(keySVO.getId());
                block6: for (LVLocaleVO locale : targetLocaleList) {
                    List stringListForLocale = manager.getStringList(locale);
                    for (LVStringVO s : stringListForLocale) {
                        if (!keySVO.getId().equals(s.getId())) continue;
                        sbContents.append(",");
                        sbContents.append(s.getValue());
                        continue block6;
                    }
                }
                sbContents.append("\n");
                sb.append(sbContents.toString());
            }
            try {
                try {
                    fWriter = new FileWriter(file);
                    fWriter.write(sb.toString());
                }
                catch (IOException e) {
                    logger.error("Fail to write localized strings", (Throwable)e);
                    IOUtil.tryFlush((Flushable[])new Flushable[]{fWriter});
                    IOUtil.tryClose((Object[])new Object[]{fWriter});
                    break block9;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryFlush((Flushable[])new Flushable[]{fWriter});
                IOUtil.tryClose((Object[])new Object[]{fWriter});
                throw throwable;
            }
            IOUtil.tryFlush((Flushable[])new Flushable[]{fWriter});
            IOUtil.tryClose((Object[])new Object[]{fWriter});
        }
    }
}

