/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.initializer;

import java.io.File;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.widl.JavaScriptWriter;

public class LibraryProvider {
    private static final String LIBRARY_FILENAME = "feature.js";
    private static LibraryProvider instance = new LibraryProvider();

    private LibraryProvider() {
    }

    public static synchronized LibraryProvider getInstance() {
        return instance;
    }

    public synchronized char[][] getLibraryFileNames(ITizenConfigurator config, IPath workingLibPath) {
        File directory = workingLibPath.toFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        Collection modules = config.getUsedModules();
        File file = workingLibPath.append(LIBRARY_FILENAME).toFile();
        if (file.exists()) {
            file.delete();
        }
        JavaScriptWriter.getInstance().writeJSForModule(modules, file);
        return new char[][]{LIBRARY_FILENAME.toCharArray()};
    }
}

