/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.tizen.web.zimlaunch.refactoring.Messages;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class ProjectRenameChange
extends RenameResourceChange {
    private ILaunchConfiguration[] configurations;
    private String newProjectName;
    private IPath resourcePath;

    public ProjectRenameChange(IPath resourcePath, ILaunchConfiguration[] configurations, String newProjectName) {
        super(resourcePath, newProjectName);
        this.resourcePath = resourcePath;
        this.configurations = configurations;
        this.newProjectName = newProjectName;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ILaunchConfiguration lc;
        ILaunchConfiguration[] removeConfigurations;
        ILaunchConfiguration[] iLaunchConfigurationArray = removeConfigurations = LaunchUtil.getLaunchConfigurations(this.newProjectName);
        int n = removeConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            lc = iLaunchConfigurationArray[n2];
            lc.delete();
            ++n2;
        }
        iLaunchConfigurationArray = this.configurations;
        n = this.configurations.length;
        n2 = 0;
        while (n2 < n) {
            lc = iLaunchConfigurationArray[n2];
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            wc.setAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", this.newProjectName);
            lc = wc.doSave();
            ++n2;
        }
        IPath path = this.resourcePath.removeLastSegments(1).append(this.newProjectName);
        return new ProjectRenameChange(path, this.configurations, this.resourcePath.lastSegment());
    }

    public String getName() {
        return Messages.CHANGE_PROJECT_NAME_IN_LAUNCH_CONFIGURATION;
    }
}

