/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.operation;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.ITizenProject;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.core.application.tproject.TprojectHandler;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;

public class TizenProjectDescriptOperation
extends AbstractProjectTemplateOperation {
    public TizenProjectDescriptOperation() {
        this.setMainTask(WizardMessages.NewWizardTizenProjectDescriptOperationTask);
    }

    @Override
    public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        TizenProjectDescription projectDescription;
        ProfileInfo profileInfo;
        TprojectHandler handler;
        TizenProjectDescription tizenProjectDescription;
        int tick = 333;
        IResource tProjResource = project.findMember(".tproject");
        if (tProjResource != null && (tizenProjectDescription = (handler = new TprojectHandler(project)).unmarshal()) != null && tizenProjectDescription.isSupportedPlatform()) {
            return true;
        }
        if (template != null && (profileInfo = template.getProfileInfo()) != null) {
            ProjectUtil.createTizenProjectDescription((IProject)project, (ProfileInfo)profileInfo);
        }
        monitor.worked(tick);
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        TizenProjectDescription tizenProjectDescription2 = projectDescription = tizenProject == null ? null : tizenProject.getDescription();
        if (projectDescription == null) {
            this.logger.warn("Couldn't get a Tizen project description.");
            return true;
        }
        monitor.worked(tick);
        if (!projectDescription.isSupportedPlatform()) {
            this.logger.warn("The platform in this project is not supported in IDE. Change to the latest platform forcibly.");
            ProfileInfo latestProfileInfo = InstallPathConfig.getLatestProfileInfo();
            if (latestProfileInfo != null) {
                ProjectUtil.updateTizenProjectDescription((IProject)project, (ProfileInfo)latestProfileInfo);
            }
        }
        monitor.worked(tick);
        return true;
    }
}

