/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.wizards.TizenCommonWizardPage;
import org.tizen.common.ui.wizards.model.Template;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.cache.ColorCache;
import org.tizen.web.apptemplate.model.LibraryElement;
import org.tizen.web.apptemplate.model.OptionElement;
import org.tizen.web.apptemplate.model.OptionGroup;
import org.tizen.web.apptemplate.model.Options;
import org.tizen.web.apptemplate.model.SupportLibraries;
import org.tizen.web.apptemplate.model.TizenTemplateLibraryType;
import org.tizen.web.project.wizard.Activator;
import org.tizen.web.project.wizard.extension.ITemplateOptionControl;
import org.tizen.web.project.wizard.model.ExtensionTemplateLoader;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.model.TizenTemplateLibrariesPool;
import org.tizen.web.project.wizard.model.TizenTemplateLibraryGroup;

public class NewWebAppProjectWizardOptionPage
extends WizardPage {
    private final Logger logger = LoggerFactory.getLogger(NewWebAppProjectWizardOptionPage.class);
    private CTabFolder tabFolder;
    private final int tabHeight = 36;
    private final int compositeMaxHeight = 410;
    private final int compositeMinWidth = 865;
    private Options options;
    private String templateRootPath;
    private final String supportLibrariesIconPath = "icons/supportLibrariesOption.png";
    private final String defaultIconPath = "icons/defaultOption.png";
    private final String SUPPORT_LIBRARIES = "Supported Libraries";
    private final String COMPRESSED_CODE = "Minified Code";
    private final String UNCOMPRESSED_CODE = "Original Code";
    private Template template;
    private TizenTemplateLibrariesPool librariesPool;
    private Map<String, ITemplateOptionControl> customControls = new HashMap<String, ITemplateOptionControl>();

    public NewWebAppProjectWizardOptionPage(String pageName) {
        super(pageName);
    }

    protected NewWebAppProjectWizardOptionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        this.tabFolder = new CTabFolder(composite, 2176);
        this.tabFolder.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 374 + this.tabFolder.getTabHeight();
        this.tabFolder.setLayoutData((Object)layoutData);
        this.tabFolder.setTabHeight(36);
        this.tabFolder.setBackground(new Color[]{ColorCache.getWhite(), ColorCache.getColor((int)217, (int)217, (int)217)}, new int[]{100}, true);
        this.tabFolder.setSelectionBackground(new Color[]{ColorCache.getColor((int)202, (int)237, (int)255), ColorCache.getColor((int)88, (int)176, (int)222)}, new int[]{100}, true);
        this.tabFolder.setSelectionForeground(ColorCache.getWhite());
        this.tabFolder.setBackgroundImage(TizenCommonWizardPage.getWizardBackgroundImage());
        this.tabFolder.setBackgroundMode(1);
        this.setControl((Control)composite);
    }

    private void destroyChildControls() {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Image tabImage = item.getImage();
            if (tabImage != null && !tabImage.isDisposed()) {
                tabImage.dispose();
            }
            if (!item.isDisposed()) {
                item.dispose();
            }
            ++n2;
        }
    }

    public void dispose() {
        Image tabFolderImage;
        if (this.tabFolder != null && (tabFolderImage = this.tabFolder.getBackgroundImage()) != null && tabFolderImage.isDisposed()) {
            tabFolderImage.dispose();
        }
        super.dispose();
    }

    private void createSupportLibrariesControl() {
        SupportLibraries libraries = this.options.getSupportLibraries();
        if (libraries == null) {
            return;
        }
        Composite composite = this.createDefaultComposite((Composite)this.tabFolder);
        this.createTabItem(composite, "Supported Libraries", "icons/supportLibrariesOption.png");
        this.librariesPool = new TizenTemplateLibrariesPool(this.template.getProfileInfo());
        for (String libraryName : this.librariesPool.getSupportLibraryNames(libraries)) {
            TizenTemplateLibraryGroup libraryGroup = this.librariesPool.getLibraryGroup(libraryName);
            if (libraryGroup == null) {
                this.logger.warn("Fail to load the specified library. could not find : " + libraryName);
                continue;
            }
            this.createSupportLibraryControl(libraryGroup, composite);
        }
    }

    public TizenTemplateLibrariesPool getTizenTemplateLibrariesPool() {
        return this.librariesPool;
    }

    public void setTizenTemplateLibrariesPool(TizenTemplateLibrariesPool librariesPool) {
        this.librariesPool = librariesPool;
    }

    private void createSupportLibraryControl(final TizenTemplateLibraryGroup libraryGroup, Composite parent) {
        Group innerGroup = this.createDefaultGroup(parent, libraryGroup.getName());
        Composite innerComposite = this.createDefaultComposite((Composite)innerGroup, 0, (Layout)new GridLayout(3, false), new GridData(1808));
        Combo combo = new Combo(innerComposite, 8);
        combo.setLayoutData((Object)new GridData(1, 0x1000000, true, true));
        final Button button1 = this.createButton(innerComposite, 16, "Original Code");
        button1.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        final Button button2 = this.createButton(innerComposite, 16, "Minified Code");
        button2.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedVersion = ((Combo)e.widget).getText();
                libraryGroup.setSelectedElementWithDependsUpdate(selectedVersion);
                libraryGroup.setSelectedMinifiedWithDependsUpdate(false);
                NewWebAppProjectWizardOptionPage.this.updateMinifiedRadioButton(libraryGroup, button1, button2);
            }
        });
        for (LibraryElement le : libraryGroup.getLibraryElements()) {
            combo.add(le.getVersion());
        }
        combo.setText(libraryGroup.getSelectedElement().getVersion());
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                libraryGroup.setSelectedMinifiedWithDependsUpdate(false);
                NewWebAppProjectWizardOptionPage.this.updateMinifiedRadioButton(libraryGroup, button1, button2);
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                libraryGroup.setSelectedMinifiedWithDependsUpdate(true);
                NewWebAppProjectWizardOptionPage.this.updateMinifiedRadioButton(libraryGroup, button1, button2);
            }
        });
        this.updateMinifiedRadioButton(libraryGroup, button1, button2);
    }

    private void updateMinifiedRadioButton(TizenTemplateLibraryGroup libraryGroup, Button button1, Button button2) {
        assert (libraryGroup != null) : "libraryGroup must not be null";
        TizenTemplateLibraryType supportLibraryType = libraryGroup.getSelectedElement().getSupportLibraryType();
        button1.setEnabled(supportLibraryType == TizenTemplateLibraryType.BOTH || supportLibraryType == TizenTemplateLibraryType.ORIGINAL);
        button2.setEnabled(supportLibraryType == TizenTemplateLibraryType.BOTH || supportLibraryType == TizenTemplateLibraryType.MINIFIED);
        boolean isSelected = libraryGroup.isSelectedMinified();
        button1.setSelection(!isSelected);
        button2.setSelection(isSelected);
    }

    public void createOptionControl(ProjectTemplate template) {
        assert (template != null) : "template must not be null";
        this.template = template;
        if (this.options == template.getTemplateOptions()) {
            return;
        }
        this.destroyChildControls();
        this.options = template.getTemplateOptions();
        this.templateRootPath = template.getTemplateRoot();
        if (this.options != null) {
            this.createSupportLibrariesControl();
            this.customControls.clear();
            for (OptionGroup group : this.options.getOptionGroup()) {
                ITemplateOptionControl customControl = this.getContributedOption(template, group.getName());
                if (SpecialOption.hasOption(group)) {
                    this.createSpecialOptionGroup(group, (Composite)this.tabFolder);
                    continue;
                }
                if (customControl != null) {
                    this.createCustomControl(group, (Composite)this.tabFolder, customControl);
                    this.customControls.put(group.getName(), customControl);
                    continue;
                }
                this.createOptionGroup(group, (Composite)this.tabFolder, false);
            }
        }
        this.updateLayout();
    }

    private ITemplateOptionControl getContributedOption(ProjectTemplate template, String optionName) {
        ITemplateOptionControl[] templateOptionControl;
        ITemplateOptionControl[] iTemplateOptionControlArray = templateOptionControl = ExtensionTemplateLoader.getInstance().getTemplateOptionControl();
        int n = templateOptionControl.length;
        int n2 = 0;
        while (n2 < n) {
            ITemplateOptionControl ctrlInterface = iTemplateOptionControlArray[n2];
            if (ctrlInterface.canUseTo(template, optionName)) {
                return ctrlInterface;
            }
            ++n2;
        }
        return null;
    }

    public ITemplateOptionControl[] getCustomControlData() {
        return this.customControls.values().toArray(new ITemplateOptionControl[0]);
    }

    private void createCustomControl(OptionGroup optionGroup, Composite parent, ITemplateOptionControl customControl) {
        String name = customControl.getTitle();
        if (StringUtil.isEmpty((CharSequence)name)) {
            name = optionGroup.getName();
        }
        String imagePath = optionGroup.getImage();
        Composite composite = this.createDefaultComposite(parent);
        this.createTabItem(composite, name, imagePath);
        customControl.createControl(composite, optionGroup);
    }

    private void createSpecialOptionGroup(final OptionGroup optionGroup, Composite parent) {
        String name = optionGroup.getName();
        String key = optionGroup.getKey();
        String imagePath = optionGroup.getImage();
        switch (SpecialOption.valueOf(key)) {
            case Theme: {
                Composite composite = this.createDefaultComposite(parent, 0, (Layout)new GridLayout(2, false), new GridData(768));
                this.createTabItem(composite, name, imagePath);
                Combo combo = new Combo(composite, 8);
                combo.setLayoutData((Object)new GridData(2));
                Composite previewContainer = this.createDefaultComposite(composite);
                final ScalableImage previewWidget = new ScalableImage(previewContainer, 0);
                previewWidget.setLayout((Layout)new GridLayout());
                previewWidget.setLayoutData(new GridData(0x1000000, 0x1000000, true, true, 1, 1));
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Combo thisCombo = (Combo)e.widget;
                        String name = thisCombo.getText();
                        for (OptionElement child : optionGroup.getOptionElement()) {
                            boolean selected = name.equals(child.getName());
                            child.setDefaultElement(Boolean.valueOf(selected));
                            if (!selected) continue;
                            NewWebAppProjectWizardOptionPage.this.updatePreviewImage(previewWidget, child);
                        }
                    }
                });
                for (OptionElement childElement : optionGroup.getOptionElement()) {
                    combo.add(childElement.getName());
                    if (childElement.isDefaultElement() == null || !childElement.isDefaultElement().booleanValue()) continue;
                    combo.setText(childElement.getName());
                    this.updatePreviewImage(previewWidget, childElement);
                }
                break;
            }
            case Viewport_Mode: {
                CTabItem item = this.findTabItem("Supported Libraries");
                if (item == null) break;
                Composite composite = (Composite)item.getControl();
                Group group = this.createDefaultGroup(composite, 0, name, (Layout)new GridLayout(), new GridData(768));
                for (OptionElement childElement : optionGroup.getOptionElement()) {
                    this.createSingleSelectionElement(childElement, (Composite)group);
                }
                break;
            }
            default: {
                this.createOptionGroup(optionGroup, (Composite)this.tabFolder, false);
            }
        }
    }

    private void updatePreviewImage(ScalableImage scalableImage, OptionElement child) {
        Image image = null;
        String imagePath = child.getImage();
        if (imagePath != null) {
            String path = String.valueOf(this.templateRootPath) + File.separator + imagePath;
            image = new Image((Device)SWTUtil.getDisplay(), path);
        }
        scalableImage.setImage(image, 865, 410 - 36);
    }

    private CTabItem findTabItem(String name) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getText().equals(name)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void createSingleSelectionElement(final OptionElement optionElement, Composite parent) {
        Button button = this.createSelectionElement(optionElement, parent, 16, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button thisButton = (Button)e.widget;
                optionElement.setDefaultElement(Boolean.valueOf(thisButton.getSelection()));
            }
        });
        if (optionElement.isDefaultElement() != null) {
            button.setSelection(optionElement.isDefaultElement().booleanValue());
        }
    }

    private void createMultiSelectionElement(final OptionElement optionElement, Composite parent) {
        Button button = this.createSelectionElement(optionElement, parent, 32, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button thisButton = (Button)e.widget;
                optionElement.setDefaultElement(Boolean.valueOf(thisButton.getSelection()));
            }
        });
        if (optionElement.isDefaultElement() != null) {
            button.setSelection(optionElement.isDefaultElement().booleanValue());
        }
    }

    private void createMandatoryElement(OptionElement optionElement, Composite parent) {
        Button button = this.createSelectionElement(optionElement, parent, 32, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button thisButton = (Button)e.widget;
                thisButton.setSelection(true);
            }
        });
        button.setSelection(true);
    }

    private void createOptionGroup(OptionGroup optionGroup, Composite parent, boolean isSubGroup) {
        Composite composite;
        String name = optionGroup.getName();
        String imagePath = optionGroup.getImage();
        if (!isSubGroup) {
            composite = this.createDefaultComposite(parent);
            this.createTabItem(composite, name, imagePath);
        } else {
            composite = this.createDefaultGroup(parent, name);
        }
        for (OptionElement childElement : optionGroup.getOptionElement()) {
            switch (optionGroup.getOptionType()) {
                case MANDATORY: {
                    this.createMandatoryElement(childElement, composite);
                    break;
                }
                case MULTI_SELECTION: {
                    this.createMultiSelectionElement(childElement, composite);
                    break;
                }
                case SINGLE_SELECTION: {
                    this.createSingleSelectionElement(childElement, composite);
                }
            }
        }
        for (OptionGroup childGroup : optionGroup.getOptionGroup()) {
            this.createOptionGroup(childGroup, composite, true);
        }
    }

    protected void updateLayout() {
        if (this.tabFolder != null) {
            this.tabFolder.getParent().layout();
            if (this.tabFolder.getSelectionIndex() == -1 && this.tabFolder.getItemCount() != 0) {
                this.tabFolder.setSelection(0);
            }
        }
    }

    private Button createSelectionElement(OptionElement optionElement, Composite parent, int style, SelectionListener listener) {
        Button button = this.createButton(parent, style, optionElement.getName(), optionElement.getDescription());
        button.addSelectionListener(listener);
        return button;
    }

    private Button createButton(Composite parent, int style, String text) {
        return this.createButton(parent, style, text, null);
    }

    private Button createButton(Composite parent, int style, String text, String toolTip) {
        Button button = new Button(parent, style);
        button.setText(text);
        if (toolTip != null && !toolTip.isEmpty()) {
            button.setToolTipText(toolTip);
        }
        return button;
    }

    private Image createTabImage(String imagePath) {
        if (imagePath == null) {
            return ImageUtil.getImage((Plugin)Activator.getDefault(), (String)"icons/defaultOption.png");
        }
        Image createdImage = null;
        try {
            String path = String.valueOf(this.templateRootPath) + File.separator + imagePath;
            createdImage = new Image((Device)SWTUtil.getDisplay(), path);
        }
        catch (SWTException sWTException) {
            createdImage = ImageUtil.getImage((Plugin)Activator.getDefault(), (String)imagePath);
        }
        return createdImage;
    }

    private CTabItem createTabItem(Composite composite, String text, String imagePath) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(text);
        Image createdImage = this.createTabImage(imagePath);
        item.setImage(createdImage);
        item.setControl((Control)composite);
        return item;
    }

    private Group createDefaultGroup(Composite parent, String text) {
        return this.createDefaultGroup(parent, 0, text, (Layout)new GridLayout(), new GridData(768));
    }

    private Group createDefaultGroup(Composite parent, int style, String text, Layout layout, Object layoutData) {
        Group group = new Group(parent, style);
        group.setText(text);
        group.setLayout(layout);
        group.setLayoutData(layoutData);
        return group;
    }

    private Composite createDefaultComposite(Composite parent) {
        return this.createDefaultComposite(parent, 0, (Layout)new GridLayout(), new GridData(1808));
    }

    private Composite createDefaultComposite(Composite parent, int style, Layout layout, Object layoutData) {
        Composite composite = new Composite(parent, style);
        composite.setLayout(layout);
        composite.setLayoutData(layoutData);
        return composite;
    }

    public class ScalableImage
    extends Canvas {
        private final double defaultRatio = 1.0;
        private Image image;
        private int scaledWidth;
        private int scaledHeight;

        public ScalableImage(Composite parent, int style) {
            super(parent, style);
            this.defaultRatio = 1.0;
            this.scaledWidth = 0;
            this.scaledHeight = 0;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setAntialias(1);
                    e.gc.setInterpolation(2);
                    if (ScalableImage.this.image != null) {
                        ImageData imageData = ScalableImage.this.image.getImageData();
                        e.gc.drawImage(ScalableImage.this.image, 0, 0, imageData.width, imageData.height, 0, 0, ScalableImage.this.scaledWidth, ScalableImage.this.scaledHeight);
                    }
                    e.gc.dispose();
                }
            });
        }

        private void disposeImage() {
            if (this.image != null && !this.image.isDisposed()) {
                this.image.dispose();
                this.image = null;
            }
        }

        public void dispose() {
            this.disposeImage();
            super.dispose();
        }

        public void setImage(Image image, int width, int height) {
            this.setVisible(false);
            this.disposeImage();
            this.image = image;
            if (image != null) {
                this.calulateScaleSize(width, height);
                this.fitLayoutData();
                this.getParent().layout();
            }
            this.redraw();
            this.setVisible(true);
        }

        private void calulateScaleSize(int width, int height) {
            ImageData imageData = this.image.getImageData();
            this.scaledWidth = imageData.width;
            this.scaledHeight = imageData.height;
            if (this.scaledWidth <= width && this.scaledHeight <= height) {
                return;
            }
            double ratioW = 1.0;
            if (this.scaledWidth != 0 && this.scaledWidth > width) {
                ratioW = (double)width / (double)this.scaledWidth;
            }
            double ratioH = 1.0;
            if (this.scaledHeight != 0 && this.scaledHeight > height) {
                ratioH = (double)height / (double)this.scaledHeight;
            }
            double ratio = ratioW > ratioH ? ratioH : ratioW;
            this.scaledWidth = (int)((double)this.scaledWidth * ratio);
            this.scaledHeight = (int)((double)this.scaledHeight * ratio);
        }

        private void fitLayoutData() {
            Object layoutObject = this.getLayoutData();
            if (layoutObject instanceof GridData) {
                GridData layoutData = (GridData)layoutObject;
                layoutData.widthHint = this.scaledWidth;
                layoutData.heightHint = this.scaledHeight;
                this.setLayoutData(layoutData);
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (this.image != null) {
                wHint = this.scaledWidth;
                hHint = this.scaledHeight;
            }
            return super.computeSize(wHint, hHint, changed);
        }
    }

    public static enum SpecialOption {
        Theme("Theme"),
        Viewport_Mode("Viewport Mode");

        private String name;

        private SpecialOption(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static boolean hasOption(OptionGroup group) {
            if (group != null) {
                SpecialOption[] specialOptionArray = SpecialOption.values();
                int n = specialOptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SpecialOption option = specialOptionArray[n2];
                    if (option.getName().equals(group.getName())) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

