/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.navigation;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.editor.Activator;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.tizen.web.editor.javascript.navigation.SymbolInformation;
import org.tizen.web.editor.javascript.navigation.SymbolNavigatorHandler;
import org.tizen.web.editor.preference.EditorPreferencePage;

public class SymbolNavigatorListSelectionDialog
extends ElementListSelectionDialog
implements JavaScriptEditorConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFile currentEditingFile = null;
    private Button lastSelectedButton = null;
    private Object[] wholeInformations = null;
    private Object[] projectInformations = null;
    private Image warningImage = null;
    private MouseAdapter scopeSelectionMouseAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent event) {
            Button selectedButton = (Button)event.widget;
            if (selectedButton.equals(SymbolNavigatorListSelectionDialog.this.lastSelectedButton)) {
                return;
            }
            SymbolNavigatorListSelectionDialog.this.lastSelectedButton = selectedButton;
            SymbolNavigatorListSelectionDialog.this.asyncRefreshSymbolNavigator(selectedButton);
        }
    };

    public SymbolNavigatorListSelectionDialog(Shell parent, ILabelProvider renderer, IFile currentEditingFile) {
        super(parent, renderer);
        this.currentEditingFile = currentEditingFile;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createCheckScopeArea(contents);
        return contents;
    }

    public void setElements(Object[] elements) {
        super.setElements(elements);
        IPreferenceStore jsEditorPreferenceStore = org.tizen.web.editor.javascript.Activator.getJsEditorPreferenceStore();
        String scopeStoreValue = jsEditorPreferenceStore.getString("org.tizen.web.editor.javascript.JS_EDITOR_SYMBOL_NAVIGATOR_SCOPE_STORE_KEY");
        if (scopeStoreValue != null && scopeStoreValue.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_WHOLE")) {
            this.wholeInformations = elements;
        } else if (scopeStoreValue != null && scopeStoreValue.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_PROJECT")) {
            this.projectInformations = elements;
        }
    }

    protected void handleElementsChanged() {
        boolean enabled = !this.fFilteredList.isEmpty();
        this.fFilteredList.setEnabled(enabled);
        this.updateOkState();
    }

    protected void handleEmptyList() {
        this.fFilteredList.setEnabled(false);
        this.updateOkState();
    }

    public boolean close() {
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        return super.close();
    }

    private void createCheckScopeArea(Composite composite) {
        Group checkScopeContainer = new Group(composite, 0);
        checkScopeContainer.setText("Lookup Scope");
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        checkScopeContainer.setLayoutData((Object)data);
        checkScopeContainer.setLayout((Layout)new RowLayout(512));
        this.createDetailCheckScope((Composite)checkScopeContainer);
    }

    private void createDetailCheckScope(final Composite composite) {
        IPreferenceStore jsEditorPreferenceStore = org.tizen.web.editor.javascript.Activator.getJsEditorPreferenceStore();
        String scopeStoreValue = jsEditorPreferenceStore.getString("org.tizen.web.editor.javascript.JS_EDITOR_SYMBOL_NAVIGATOR_SCOPE_STORE_KEY");
        Button global = new Button(composite, 16);
        global.setText("Including project's include path libraries");
        global.setData("org.tizen.web.editor.javascript.JS_EDITOR_SYMBOL_NAVIGATOR_SCOPE_STORE_KEY", (Object)"SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_WHOLE");
        global.addMouseListener((MouseListener)this.scopeSelectionMouseAdapter);
        if (scopeStoreValue.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_WHOLE")) {
            global.setSelection(true);
            this.lastSelectedButton = global;
        }
        Button onlyProject = new Button(composite, 16);
        onlyProject.setText("In a current project");
        onlyProject.setData("org.tizen.web.editor.javascript.JS_EDITOR_SYMBOL_NAVIGATOR_SCOPE_STORE_KEY", (Object)"SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_PROJECT");
        onlyProject.addMouseListener((MouseListener)this.scopeSelectionMouseAdapter);
        if (scopeStoreValue.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_PROJECT")) {
            onlyProject.setSelection(true);
            this.lastSelectedButton = onlyProject;
        }
        Button onlyFile = new Button(composite, 16);
        onlyFile.setText("In a current file");
        onlyFile.setData("org.tizen.web.editor.javascript.JS_EDITOR_SYMBOL_NAVIGATOR_SCOPE_STORE_KEY", (Object)"SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_THIS_FILE");
        onlyFile.addMouseListener((MouseListener)this.scopeSelectionMouseAdapter);
        if (scopeStoreValue.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_THIS_FILE")) {
            onlyFile.setSelection(true);
            this.lastSelectedButton = onlyFile;
        }
        Text line = new Text(composite, 66);
        line.setBackground(composite.getBackground());
        line.setText("");
        Composite warningContainer = new Composite(composite, 0);
        warningContainer.setLayout((Layout)new RowLayout(256));
        this.warningImage = this.getShell().getDisplay().getSystemImage(2);
        this.warningImage = this.resize(this.warningImage, 16, 16);
        Label warning = new Label(warningContainer, 0);
        warning.setBackground(composite.getBackground());
        warning.setImage(this.warningImage);
        warning.setSize(16, 16);
        Text caution = new Text(warningContainer, 4);
        caution.setBackground(composite.getBackground());
        caution.setText("NOTICE :");
        Text cautionExplanation = new Text(composite, 66);
        cautionExplanation.setBackground(composite.getBackground());
        cautionExplanation.setText("The symbols that are contained in excluded folders are not listed.\nYou can set the exclude folders through the link below.");
        Link preferenceLink = new Link(composite, 0);
        preferenceLink.setText("<a>Project Resource Lookup Setting</a>");
        preferenceLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedPage;
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)"org.tizen.web.edit.EditorPreferencePage", (String[])new String[]{"org.tizen.web.edit.EditorPreferencePage"}, null);
                int result = preferenceDialog.open();
                if (result == 0 && (selectedPage = preferenceDialog.getSelectedPage()) instanceof EditorPreferencePage) {
                    String oldExcludedFoldersText = ((EditorPreferencePage)selectedPage).getOldExcludedFoldersText();
                    IPreferenceStore editorPreferenceStore = Activator.getCommonEditorPreferenceStore();
                    String scopeStoreValue = editorPreferenceStore.getString("org.tizen.web.editor.EDITOR_ADVANCED_FEATURE_EXCLUDED_FOLDER_STORE_KEY");
                    if (oldExcludedFoldersText != null && !oldExcludedFoldersText.equals(scopeStoreValue)) {
                        SymbolNavigatorListSelectionDialog.this.wholeInformations = null;
                        SymbolNavigatorListSelectionDialog.this.projectInformations = null;
                        SymbolNavigatorListSelectionDialog.this.asyncRefreshSymbolNavigator(SymbolNavigatorListSelectionDialog.this.lastSelectedButton);
                    }
                }
            }
        });
        preferenceLink.setEnabled(true);
    }

    private Image resize(Image image, int width, int height) {
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        return scaled;
    }

    private void asyncRefreshSymbolNavigator(final Button selectedButton) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                String data = (String)selectedButton.getData("org.tizen.web.editor.javascript.JS_EDITOR_SYMBOL_NAVIGATOR_SCOPE_STORE_KEY");
                IPreferenceStore jsEditorPreferenceStore = org.tizen.web.editor.javascript.Activator.getJsEditorPreferenceStore();
                jsEditorPreferenceStore.setValue("org.tizen.web.editor.javascript.JS_EDITOR_SYMBOL_NAVIGATOR_SCOPE_STORE_KEY", data);
                try {
                    if (data.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_WHOLE") && SymbolNavigatorListSelectionDialog.this.wholeInformations != null) {
                        int size;
                        int selectionIndex = SymbolNavigatorListSelectionDialog.this.getSelectionIndex();
                        if (selectionIndex > (size = SymbolNavigatorListSelectionDialog.this.wholeInformations.length)) {
                            SymbolNavigatorListSelectionDialog.this.setSelection(null);
                        }
                        SymbolNavigatorListSelectionDialog.this.setListElements(SymbolNavigatorListSelectionDialog.this.wholeInformations);
                        return;
                    }
                    if (data.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_PROJECT") && SymbolNavigatorListSelectionDialog.this.projectInformations != null) {
                        int size;
                        int selectionIndex = SymbolNavigatorListSelectionDialog.this.getSelectionIndex();
                        if (selectionIndex > (size = SymbolNavigatorListSelectionDialog.this.projectInformations.length)) {
                            SymbolNavigatorListSelectionDialog.this.setSelection(null);
                        }
                        SymbolNavigatorListSelectionDialog.this.setListElements(SymbolNavigatorListSelectionDialog.this.projectInformations);
                        return;
                    }
                    List<SymbolInformation> makeSymbolInformations = SymbolNavigatorHandler.makeSymbolInformations(SymbolNavigatorListSelectionDialog.this.currentEditingFile);
                    Collections.sort(makeSymbolInformations);
                    if (makeSymbolInformations != null && makeSymbolInformations.size() > 0) {
                        int size;
                        int selectionIndex = SymbolNavigatorListSelectionDialog.this.getSelectionIndex();
                        if (selectionIndex > (size = makeSymbolInformations.size())) {
                            SymbolNavigatorListSelectionDialog.this.setSelection(null);
                        }
                        SymbolNavigatorListSelectionDialog.this.setListElements(makeSymbolInformations.toArray());
                        if (data.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_WHOLE") && SymbolNavigatorListSelectionDialog.this.wholeInformations == null) {
                            SymbolNavigatorListSelectionDialog.this.wholeInformations = makeSymbolInformations.toArray();
                        }
                        if (data.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_PROJECT") && SymbolNavigatorListSelectionDialog.this.projectInformations == null) {
                            SymbolNavigatorListSelectionDialog.this.projectInformations = makeSymbolInformations.toArray();
                        }
                    } else {
                        SymbolNavigatorListSelectionDialog.this.setSelection(null);
                        SymbolNavigatorListSelectionDialog.this.setListElements(new Object[0]);
                    }
                }
                catch (ExecutionException e) {
                    SymbolNavigatorListSelectionDialog.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

