/*
 * Decompiled with CFR 0.152.
 */
package json.editors;

import java.util.HashMap;
import java.util.List;
import json.JsonEditorPlugin;
import json.editors.JsonSourceViewerConfiguration;
import json.model.jsonnode.JsonNode;
import json.outline.JsonContentOutlinePage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class JsonTextEditor
extends TextEditor {
    private JsonSourceViewerConfiguration viewerConfiguration;
    protected static final char[] PAIRS = new char[]{'{', '}', '[', ']'};
    private DefaultCharacterPairMatcher pairsMatcher = new DefaultCharacterPairMatcher(PAIRS);
    private JsonContentOutlinePage fOutlinePage;
    private ProjectionAnnotationModel annotationModel;
    private ProjectionSupport projectionSupport;
    private Annotation[] oldAnnotations;

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.pairsMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("#JsonTextEditorContext");
        this.setRulerContextMenuId("#JsonTextRulerContext");
        this.viewerConfiguration = new JsonSourceViewerConfiguration(this);
        this.setSourceViewerConfiguration(this.viewerConfiguration);
    }

    public void dispose() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(null);
        }
        if (this.pairsMatcher != null) {
            this.pairsMatcher.dispose();
            this.pairsMatcher = null;
        }
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(input);
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new JsonContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
        SourceViewerDecorationSupport support = this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        support.install(JsonEditorPlugin.getJsonPreferenceStore());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure(List<Position> positions) {
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }

    public JsonContentOutlinePage getFOutlinePage() {
        return this.fOutlinePage;
    }

    public void updateContentOutlinePage(List<JsonNode> jsonNodes) {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setJsonNodes(jsonNodes);
        }
    }
}

