/*
 * Decompiled with CFR 0.152.
 */
package json.outline;

import java.util.List;
import json.model.jsonnode.JsonNode;
import json.outline.JsonContentProvider;
import json.outline.JsonLabelProvider;
import json.outline.node.JsonTreeNode;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class JsonContentOutlinePage
extends ContentOutlinePage
implements ISelectionListener {
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;
    protected JsonContentProvider fContentProvider;

    public JsonContentOutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
        this.fContentProvider = new JsonContentProvider(this.fDocumentProvider);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        DelegatingStyledCellLabelProvider delegatingStyledCellLabelProvider = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new JsonLabelProvider());
        viewer.setLabelProvider((IBaseLabelProvider)delegatingStyledCellLabelProvider);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
            this.fContentProvider.setInput(this.fInput);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            JsonTreeNode jsonTreeNode = (JsonTreeNode)((IStructuredSelection)selection).getFirstElement();
            if (jsonTreeNode.isTextSelection()) {
                jsonTreeNode.setTextSelection(false);
                return;
            }
            int start = jsonTreeNode.getStart();
            int length = jsonTreeNode.getLength();
            try {
                this.fTextEditor.selectAndReveal(start, length);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fTextEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.fContentProvider.setInput(this.fInput);
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            control.setRedraw(true);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        int length;
        ITextSelection textSelection;
        int start;
        JsonTreeNode element;
        if (selection instanceof ITextSelection && (element = this.fContentProvider.findNearestElement(start = (textSelection = (ITextSelection)selection).getOffset(), length = textSelection.getLength())) != null) {
            element.setTextSelection(true);
            this.getTreeViewer().reveal((Object)element);
            TreeSelection treeSelection = new TreeSelection(new TreePath(new Object[]{element}));
            this.getTreeViewer().setSelection((ISelection)treeSelection);
        }
    }

    public void setJsonNodes(List<JsonNode> jsonNodes) {
        this.fContentProvider.setJsonNodes(jsonNodes);
        if (this.fContentProvider.rootObject == null) {
            this.update();
        } else {
            TreeViewer viewer = this.getTreeViewer();
            if (viewer != null) {
                viewer.refresh();
            }
        }
    }
}

