/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.support;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.tizen.web.localization.support.FilteredFilesContentProvider;
import org.tizen.web.localization.support.PatternConstructor;

public class LocalizedFilesContentProvider
extends FilteredFilesContentProvider {
    @Override
    public Object[] getElements(Object inputElement) {
        Object[] objects = super.getElements(inputElement);
        return this.findLocalizedFiles(objects);
    }

    private Object[] findLocalizedFiles(Object[] objects) {
        ArrayList<IFile> fileNotFromLocalizeFolders = new ArrayList<IFile>();
        ArrayList<IFile> fileFromLocalizeFolders = new ArrayList<IFile>();
        ArrayList<IFile> localizedFiles = new ArrayList<IFile>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                if (this.isChildOfLocaleFolder(file)) {
                    fileFromLocalizeFolders.add(file);
                } else {
                    fileNotFromLocalizeFolders.add(file);
                }
            }
            ++n2;
        }
        for (IFile file : fileNotFromLocalizeFolders) {
            for (IFile lFile : fileFromLocalizeFolders) {
                if (!lFile.getName().equals(file.getName()) || localizedFiles.contains(file)) continue;
                localizedFiles.add(file);
            }
        }
        return localizedFiles.toArray();
    }

    private boolean isChildOfLocaleFolder(IFile file) {
        IPath path = file.getFullPath();
        return PatternConstructor.createPattern("*/locales/*", true).matcher(path.toString().toLowerCase()).matches();
    }
}

