/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.ui;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.tizen.web.localization.support.ProjectFileItem;
import org.tizen.web.localization.support.ProjectFilesCheckboxStateProvider;
import org.tizen.web.localization.support.ProjectFilesContentProvider;
import org.tizen.web.localization.support.ProjectFilesLabelProvider;
import org.tizen.web.localization.ui.Messages;

public class FilesListSelectionWizardPage
extends WizardPage {
    private Composite container;
    private CheckboxTableViewer listViewer;
    private IProject project;
    private ProjectFilesContentProvider contentProvider;
    private ProjectFilesLabelProvider labelProvider;
    private ProjectFilesCheckboxStateProvider checkboxStateProvider;
    List<IFile> selectedFiles;
    List<IFile> localizedFiles;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 370;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;

    protected FilesListSelectionWizardPage(String pageName, IProject project, List<IFile> selectedFiles, List<IFile> localizedFiles) {
        super(pageName);
        this.selectedFiles = selectedFiles;
        this.localizedFiles = localizedFiles;
        this.setProject(project);
        this.setContentProvider(new ProjectFilesContentProvider());
        this.setLabelProvider(new ProjectFilesLabelProvider());
        this.setCheckboxStateProvider(new ProjectFilesCheckboxStateProvider());
        this.setTitle(Messages.FilesListSelectionWizardPage_0);
        this.setDescription(Messages.FilesListSelectionWizardPage_1);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.createMessageArea(this.container, Messages.FilesListSelectionWizardPage_2);
        Group hintsGroup = new Group(this.container, 2048);
        GridLayout hintGroupLayout = new GridLayout();
        hintGroupLayout.numColumns = 1;
        hintsGroup.setLayout((Layout)hintGroupLayout);
        hintsGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        hintsGroup.setText(Messages.FilesListSelectionWizardPage_3);
        Composite hintsContainer = new Composite((Composite)hintsGroup, 0);
        GridLayout hintsLayout = new GridLayout();
        hintsLayout.numColumns = 1;
        hintsLayout.marginLeft = 10;
        hintsContainer.setLayout((Layout)hintsLayout);
        this.createMessageArea(hintsContainer, Messages.FilesListSelectionWizardPage_4);
        int style = 101154;
        Composite list_container = new Composite(this.container, 0);
        GridLayout list_layout = new GridLayout();
        list_layout.numColumns = 2;
        list_layout.marginWidth = 0;
        list_layout.marginHeight = 0;
        list_container.setLayout((Layout)list_layout);
        list_container.setLayoutData((Object)new GridData(4, 128, true, true));
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)list_container, (int)style);
        GridData data = new GridData(1808);
        data.heightHint = 370;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.listViewer.setCheckStateProvider((ICheckStateProvider)this.getCheckboxStateProvider());
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilesListSelectionWizardPage.this.onCheckStateChanged(event);
            }
        });
        this.addSelectionButtons(list_container);
        this.initializeViewer();
        this.createMessageArea(this.container, Messages.Next);
        this.setControl((Control)this.container);
        this.onPageChanged();
        this.setPageComplete(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "org.tizen.ide.web.localize_widget_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.container.setFocus();
        }
    }

    private void initializeViewer() {
        this.listViewer.setInput((Object)this.project);
    }

    private Label createMessageArea(Composite parent, String message) {
        Label label = new Label(parent, 0);
        label.setText(message);
        return label;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 8;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setSize(300, 0);
        buttonComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Button selectButton = new Button(buttonComposite, 8);
        selectButton.setText(Messages.FilesListSelectionWizardPage_6);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesListSelectionWizardPage.this.listViewer.setAllChecked(true);
                FilesListSelectionWizardPage.this.onPageChanged();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = new Button(buttonComposite, 8);
        deselectButton.setText(Messages.FilesListSelectionWizardPage_7);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] grayedElements;
                FilesListSelectionWizardPage.this.listViewer.setAllChecked(false);
                Object[] objectArray = grayedElements = FilesListSelectionWizardPage.this.listViewer.getGrayedElements();
                int n = grayedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    FilesListSelectionWizardPage.this.listViewer.setChecked(element, true);
                    ++n2;
                }
                FilesListSelectionWizardPage.this.onPageChanged();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void onCheckStateChanged(CheckStateChangedEvent event) {
        ProjectFileItem pf = (ProjectFileItem)event.getElement();
        if (pf.isLoclized()) {
            event.getCheckable().setChecked((Object)pf, true);
        }
        this.onPageChanged();
    }

    protected void pageChanged() {
        this.onPageChanged();
    }

    protected void onPageChanged() {
        ProjectFileItem pf;
        Object obj;
        int n;
        int n2;
        Object[] objectArray;
        if (this.listViewer.getTable().getItemCount() == 0) {
            this.setErrorMessage(Messages.FilesListSelectionWizardPage_8);
        } else {
            this.setErrorMessage(null);
        }
        this.setPageComplete(this.listViewer.getCheckedElements().length > 0 || this.listViewer.getGrayedElements().length > 0);
        this.selectedFiles.clear();
        this.localizedFiles.clear();
        Object[] checkedElements = this.listViewer.getCheckedElements();
        Object[] greyedElements = this.listViewer.getGrayedElements();
        if (checkedElements.length > 0) {
            objectArray = checkedElements;
            n2 = checkedElements.length;
            n = 0;
            while (n < n2) {
                obj = objectArray[n];
                pf = (ProjectFileItem)obj;
                this.selectedFiles.add(pf.getFile());
                ++n;
            }
        }
        if (greyedElements.length > 0) {
            objectArray = greyedElements;
            n2 = greyedElements.length;
            n = 0;
            while (n < n2) {
                obj = objectArray[n];
                pf = (ProjectFileItem)obj;
                this.localizedFiles.add(pf.getFile());
                ++n;
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.listViewer.getCheckedElements().length > 0 || this.listViewer.getGrayedElements().length > 0;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setContentProvider(ProjectFilesContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public ProjectFilesContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setLabelProvider(ProjectFilesLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ProjectFilesLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setCheckboxStateProvider(ProjectFilesCheckboxStateProvider checkboxStateProvider) {
        this.checkboxStateProvider = checkboxStateProvider;
    }

    public ProjectFilesCheckboxStateProvider getCheckboxStateProvider() {
        return this.checkboxStateProvider;
    }

    public List<IFile> getSelectedFiles() {
        return this.selectedFiles;
    }

    public List<IFile> getLocalizedFiles() {
        return this.localizedFiles;
    }
}

