/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui.popup;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CancellationException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.tizen.common.core.command.CommandCancelException;
import org.tizen.common.ui.dialog.NotificationIconType;
import org.tizen.common.ui.dialog.NotificationTrayPopup;
import org.tizen.common.ui.dialog.ShowQuestionToggleDialog;
import org.tizen.common.util.Assert;
import org.tizen.common.util.NotificationType;
import org.tizen.common.util.NotifierDialog;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.ViewUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.util.ConfigurationUtil;
import org.tizen.web.packager.ui.popup.BuildPackageWithProgress;
import org.tizen.web.packager.ui.popup.Messages;

public class BuildPackageHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String msg;
        BuildPackageWithProgress bpp;
        IWorkbenchWindow window;
        IProject project;
        block7: {
            project = ProjectUtil.getProject((ExecutionEvent)event);
            Assert.notNull((Object)project);
            window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            Assert.notNull((Object)window);
            this.checkCondition(project);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell()){

                protected void cancelPressed() {
                    this.getProgressMonitor().subTask(Messages.SUBTASK_CANCEL_JOB);
                    super.cancelPressed();
                }
            };
            bpp = new BuildPackageWithProgress(project);
            project.refreshLocal(2, null);
            dialog.run(true, true, (IRunnableWithProgress)bpp);
            msg = bpp.getResultMessage();
            if (msg != null) break block7;
            return null;
        }
        try {
            if (bpp.isSuccess()) {
                NotificationTrayPopup.notify((String)Messages.POPUP_TITLE, (String)msg, (NotificationIconType)NotificationIconType.CHECK);
            } else {
                MessageDialog.openError((Shell)window.getShell(), (String)Messages.POPUP_TITLE, (String)msg);
            }
            project.refreshLocal(2, null);
        }
        catch (InvocationTargetException e) {
            String errMsg = String.valueOf(Messages.CREATING_PACAKGE_WAS_FAILED) + "\n\nCause:\n     " + e.getLocalizedMessage();
            if (!(e.getCause() instanceof CancellationException) && !(e.getCause() instanceof CommandCancelException)) {
                MessageDialog.openError((Shell)ViewUtil.getWorkbenchWindow().getShell(), (String)Messages.POPUP_TITLE, (String)errMsg);
                throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            String errMsg = String.valueOf(Messages.CREATING_PACAKGE_WAS_FAILED) + "\n\ncause: " + e.getLocalizedMessage();
            MessageDialog.openError((Shell)ViewUtil.getWorkbenchWindow().getShell(), (String)Messages.POPUP_TITLE, (String)errMsg);
            throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    private void checkCondition(IProject project) {
        String projectVersion = ProjectUtil.getTizenProjectDescription((IProject)project).getVersion();
        String configurationVersion = this.getConfigurationVersion(project);
        if (configurationVersion == null) {
            return;
        }
        if (!projectVersion.equalsIgnoreCase(configurationVersion)) {
            String message = NLS.bind((String)Messages.WRAN_VERSION_IS_DIFFERENT, (Object)configurationVersion, (Object)projectVersion);
            NotifierDialog.notify((String)Messages.TITLE_DIFFERENT_VERSION, (String)message, (NotificationType)NotificationType.WARN);
        }
    }

    private String getConfigurationVersion(IProject project) {
        try {
            return ConfigurationUtil.getRequiredVersion((IProject)project);
        }
        catch (CoreException coreException) {
        }
        catch (ConfigurationException configurationException) {}
        return null;
    }

    public static boolean continueToPackage(String title, String message, String toogleMessage, String togglePreferenceKey) {
        ShowQuestionToggleDialog dialogRunnable = new ShowQuestionToggleDialog(title, message, toogleMessage, togglePreferenceKey);
        Display.getDefault().syncExec((Runnable)dialogRunnable);
        return dialogRunnable.wantToContinue();
    }
}

