/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui.properties.multi.view;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.tizen.web.packager.ui.properties.multi.Messages;
import org.tizen.web.packager.ui.properties.multi.control.ReferenceController;
import org.tizen.web.packager.ui.properties.multi.view.IMultiPropertyTableColumn;
import org.tizen.web.packager.ui.properties.multi.view.MultiSelectionEditingSupport;
import org.tizen.web.packager.ui.properties.multi.view.SingleSelectionEditingSupport;
import org.tizen.web.packager.ui.properties.multi.view.provider.ReferenceProjectLabelProvider;

public enum WebReferenceTableColumn implements IMultiPropertyTableColumn
{
    ReferenceProject(Messages.SWT_COLUMN_PROPERTY_REFERENCE_PROJECT, 16384, Messages.SWT_COLUMN_TOOLTIP_COMPANION, 100, new ReferenceProjectLabelProvider()),
    MultiSelectableProject(Messages.SWT_COLUMN_PROPERTY_REFERENCE_PROJECT, 16384, "", 100, new ReferenceProjectLabelProvider());

    private String columnName;
    private int columnWeight;
    private boolean isResizable = false;
    private String toolTip = "";
    private CellLabelProvider clp;
    private int style = 0;

    private WebReferenceTableColumn(String columnName, int columnWeight) {
        this.columnName = columnName;
        this.columnWeight = columnWeight;
    }

    private WebReferenceTableColumn(String columnName, int columnWeight, boolean isResizable) {
        this(columnName, columnWeight);
        this.isResizable = isResizable;
    }

    private WebReferenceTableColumn(String columnName, String toolTip, int columnWeight) {
        this(columnName, columnWeight);
        this.toolTip = toolTip;
    }

    private WebReferenceTableColumn(String columnName, int style, String toolTip, int columnWeight, CellLabelProvider clp) {
        this(columnName, columnWeight);
        this.style = style;
        this.clp = clp;
        this.toolTip = toolTip;
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public int getWeight() {
        return this.columnWeight;
    }

    @Override
    public boolean isResizable() {
        return this.isResizable;
    }

    @Override
    public EditingSupport getEditingSupport(TableViewer tableViewer, ReferenceController rc) {
        switch (this) {
            case ReferenceProject: {
                return new SingleSelectionEditingSupport(tableViewer, rc);
            }
            case MultiSelectableProject: {
                return new MultiSelectionEditingSupport(tableViewer, rc);
            }
        }
        return null;
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }

    @Override
    public CellLabelProvider getLabelProvider() {
        return this.clp;
    }

    @Override
    public int getStyle() {
        return this.style;
    }
}

